"module.genes" <-
function(module, eqtls, eInfo, mInfo, cis.dist){
    moduleGene = list()
    chr.syms = names(module)
    for(c in 1:length(chr.syms)){
        chr.sym = chr.syms[c]
        if(chr.sym == "neqtlCut"){ next }
        mod.syms = names(module[[chr.sym]])
        
        for(i in 1:length(mod.syms)){
            mod.sym = mod.syms[i]
            
            markers = module[[chr.sym]][[mod.sym]]
            mod.cen = markers[1]
            matches = eqtls$markerID %in% markers
            geneIDs = eqtls$geneID[matches]
            eqtlSub = eqtls[matches,]
            markerIDs = eqtls$markerID[matches]

            eInfos  = eInfo[match(geneIDs, eInfo$ID),]
            mInfos  = mInfo[match(markerIDs, mInfo$ID),]
            
            # ------------------------------------------- #
            # check cis-linakge
            # ------------------------------------------- #
            cis = numeric(nrow(eInfos))
            gene.start = pmin(as.numeric(eInfos$start), as.numeric(eInfos$end))
            gene.end   = pmax(as.numeric(eInfos$start), as.numeric(eInfos$end))
            
            marker.pos = as.numeric(mInfos$start)
            
            if(!("chr" %in% names(eInfos))){
                stop("no variable chr in eInfo\n")
            }
            if(!("chr" %in% names(mInfos))){
                stop("no variable chr in mInfo\n")
            }

            cis1 = eInfos$chr == mInfos$chr
            cis2 = abs(gene.start - marker.pos) <= cis.dist
            cis3 = abs(gene.end - marker.pos) <= cis.dist
            cis4 = (marker.pos >= gene.start) & (marker.pos <= gene.end)
        
            cis[cis1 & (cis2 | cis3 | cis4)] = 1
            
            modGene = data.frame(eInfos, mInfos, eqtlSub, cis)
            modGene = modGene[,-(10:11)]
            tt = names(modGene)
            tt[1] = "geneID"
            tt[4:6] = c("geneChr","geneStart","geneEnd")
            tt[7:9] = c("markerID","markerChr","markerPos")
            names(modGene) = tt
            
            # ------------------------------------------- #
            # order by gene symbol
            # ------------------------------------------- #
            o.geneSym = order(modGene$geneSym)
            modGene = modGene[o.geneSym,]
            
            new.sym = paste(chr.sym, mod.sym, sep="_")
            moduleGene[[new.sym]] = modGene
        }
    }
    
    class(moduleGene) = "module.genes"
    moduleGene
}

