"lrt.power" <-
function(n.sample, n.simu, plrt.cut, prop.cut, pvals, ns, ds){

    if(n.sample%%2!=0){
        stop("n.sample must be an even numbers\n")
    }
    n.half = n.sample/2

    ## --- x1 is the true eQTL ---
    x1 = rep(0:1, c(n.half, n.half))
    
    ## --- false positive rates and false negative rates ---
    fpr = fnr = matrix(NA, nrow=length(ns), ncol=length(ds))
    
    for(p in 1:length(ns)){
        n = ns[p]
        cat("n =", n, "\n")
        
        n.cut = n*prop.cut
        
        for(q in 1:length(ds)){
            d = ds[q]
            cat("d =", d, "\n")
            
            x2 = rep(0:1, c(n.half-d, n.half+d))
            x3 = rep(0:1, c(n.half+d, n.half-d))
            
            pi = matrix(0, nrow=n.simu, ncol=2)
            
            ## --- iterate all the n.simu simulations for one n and one d ---
            i = 1

            while(i <= n.simu){
            
                pv = sample(pvals, n, replace=TRUE)
                pj = matrix(0, nrow=n, ncol=2)
                dims = c(n.sample, n, d)
                
                ## --- d.f. of t-test is approximated by n.sample-2 ---
                ts  = abs(qt(pv/2, n.sample-2))
                sigmas = 0.5*sqrt(n.sample)/ts

                SW = .C("lrt_power", as.integer(dims), as.double(x1), 
                    as.double(x2), as.double(x3), as.double(sigmas), 
                    as.double(pv), pj=as.double(t(pj)), PACKAGE="eqtl.TF")
                
                pj = matrix(SW$pj, byrow=TRUE, nrow=n, ncol=2)
                
                for(k in 1:2){
                    which.kp = which(pj[,k] < plrt.cut)
                    if(length(which.kp) > n.cut){
                        pi[i,k] = 1
                    }
                }
                
                i = i + 1
            }
            fpr[p,q] = 1 - sum(pi[,1])/n.simu
            fnr[p,q] = sum(pi[,2])/n.simu
        }
    }
    
    rownames(fpr) = ns
    colnames(fpr) = ds

    rownames(fnr) = ns
    colnames(fnr) = ds
    
    list(fpr=fpr, fnr=fnr)
}

