"causal.parCor" <-
function(y0, y1, y2, p.cut=0.01){

    if(!is.numeric(y0)){
        stop("y0 must be numeric vector\n")
    }
    if(!is.numeric(y1)){
        stop("y1 must be numeric vector\n")
    }
    if(!is.numeric(y2)){
        stop("y2 must be numeric vector\n")
    }

    if(length(y1) != length(y0) || length(y2) != length(y0)){
        stop("length of y0, y1 and y2 must be the same\n")
    }
    
    cors = numeric(6)
    labl = ""
    
    keep = !(is.na(y0) | is.na(y1) | is.na(y2))
    y0   = y0[keep]
    y1   = y1[keep]
    y2   = y2[keep]
    
    # ---------------------------------------- #
    # 1. causal model: y0 -> y1 -> y2
    # ---------------------------------------- #
    y0.r = lm(y0 ~ y1)$resid
    y2.r = lm(y2 ~ y1)$resid
    l    = lm(y2.r ~ y0.r)  ### p-value of lm(y~x) = p-value of lm(x~y)
    cors[1] = cor(y0.r, y2.r)
    cors[2] = summary(l)$coef[2,4]
    
    # ---------------------------------------- #
    # 2. reactive model: y0 -> y2 -> y1
    # ---------------------------------------- #
    y0.r = lm(y0 ~ y2)$resid
    y1.r = lm(y1 ~ y2)$resid
    l    = lm(y1.r ~ y0.r)
    cors[3] = cor(y0.r, y1.r)
    cors[4] = summary(l)$coef[2,4]
    
    # ---------------------------------------- #
    # 3. independent model: y1 <- y0 -> y2
    # ---------------------------------------- #
    y1.r = lm(y1 ~ y0)$resid
    y2.r = lm(y2 ~ y0)$resid
    l    = lm(y2.r ~ y1.r)
    cors[5] = cor(y1.r, y2.r)
    cors[6] = summary(l)$coef[2,4]
    
    # ---------------------------------------- #
    # draw conclusion
    # ---------------------------------------- #
    
    if(cors[2]>p.cut & cors[4]<p.cut & cors[6]<p.cut){
        labl = "causal"
    }else if(cors[2]<p.cut & cors[4]>p.cut & cors[6]<p.cut){
        labl = "reactive"
    }else if(cors[2]<p.cut & cors[4]<p.cut & cors[6]>p.cut){
        labl = "independent"
    }else{
        labl = "unknonwn"
    }
    
    result = list(parCor=cors, label=labl)
    result
}

