\name{yeastMarkers}
\alias{yeastMarkers}
\docType{data}
\title{ genetic marker data of 40 yeast segregants }
\description{
  3313 genetic markers across 40 yeast segregants
}
\usage{data(yeastMarkers)}
\format{
  A data frame with 3313 observations on the following 43 variables.
  \describe{
    \item{\code{ID}}{a numeric vector}
    \item{\code{CHR}}{a numeric vector, Chromosome}
    \item{\code{POSITION}}{a numeric vector, Position on the Chromosome}
    \item{\code{EXP1-EXP40}}{numeric vectors of markers data}
  }
}
\details{
  Brem et. al. grew yeast segregants from a cross between two budding yeast
  strains: a standard laboratory strain (BY) and a wild isolate from a
  California vineyard (RM). They use oligonucleotide microarray to select and 
  genotype 3313 single nucleotide polymorphism (SNP) markers, which cover 99%
  of the genome.
}
\source{
  Leonid Kruglyak's laboratorys website: 
  http://www.fhcrc.org/labs/kruglyak/Data
}
\references{
  Brem RB, Yvert G, Clinton R, Kruglyak L. Genetic dissection of transcriptional
  regulation in budding yeast. Science. 2002 Apr 26;296(5568):752-5.
}
\note{
The authors thank Rachel B. Brem and Leonid Kruglyak for the permission to include the eQTL data in our R package. However the data in the R package is just our version of data and Brem & Kruglyak aren't responsible for any errors and are not updating it to reflect any changes/improvements in the data set. 
}
\examples{
data(yeastMarkers)
}
\keyword{datasets}
