\name{impute.geno}
\alias{impute.geno}
\title{ impute genotype data }
\description{
    Simply impute the genotype of one marker by nearest non-missing marker.
    This simplified imputation only works when the position of markers are 
    give, either physical position or genetic position. Some more sophisticated
    method exists for genotype imputation, for example, function fill.geno in
    package qtl. \bold{This is a simplified solution. Result is not reliable.}
}
\usage{
impute.geno(mm, im)
}
\arguments{
  \item{mm}{ matrix of marker data, each row represent data of one marker.
    Markers should be ordered the same as im. }
  \item{im}{ data.frame of marker information, each row represent information
    of one marker. Markers should be ordered the same as mm. There must be
    two components in the data.frame: CHR (chromosome) and POSITION (physical
    or genetic position in the chromosome }
}
\details{
}
\value{
  a data matrix of the imputed data
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ 
}

\seealso{ \code{\link{nn.hclust}} }
\examples{
data(yeastMarkers)
mm = data.matrix(yeastMarkers[,(4:43)])
im = yeastMarkers[,1:3]

# drop markers with too many missing values 
# and drop individuals with too many missing values
mmKeep = dropNA(mm)
mm = mmKeep$data
im = im[mmKeep$rowKeep,]

# impute missing value in genotype data simply by nearest neighbor
mm  = impute.geno(mm, im)

}
\keyword{ methods }

