\name{get.mb}
\alias{get.mb}
\title{ construct marker blocks }
\description{
    construct marker blocks using nearest neighbor clustering algorithm
    \code{\link{nn.hclust}}).
}
\usage{
get.mb(mm, im, cut, method="complete", dis="manhattan")
}
\arguments{
  \item{mm}{ matrix of marker data, each row represent data of one marker.
    Markers should be ordered the same as im. }
  \item{im}{ data.frame of marker information, each row represent information
    of one marker. Markers should be ordered the same as mm. There must be
    two components in the data.frame: CHR (chromosome) and POSITION (physical
    or genetic position in the chromosome }
  \item{cut}{ the cut-off at which the hierarchical clustering tree is cut
    and marker blocks are generated }
  \item{method}{ the agglomeration method to be used. Now only "complete" 
    is supported }
  \item{dis}{ the distance measure to be used. Now only "manhattan" 
    is supported }
}
\details{
  chromosome by chromosome, hierarchical tree of genetic markers are generated 
  by function \code{\link{nn.hclust}}. Then the tree is cut at the given
  cut-off, and resulting clusters of markers form marker blocks. For each marker
  block, the centroid is calculated and the marker that is nearest to the
  centroid are chosen to represent the marker block (if there is several 
  such markers, the first one is chosen).
}
\value{
    a list with two components, data and info. 
    \item{data}{
        a matrix of marker block data, each row corresponds to one marker block.
        actually each row is the data of one marker that is nearest to the 
        centroid of the marker block.
    }
    \item{info}{
        a data.frame of marker block information, each row corresponds to one
        marker block. There are five components in the data.frame: "ID", "CHR",
        "START", "END" and "N.MARKER". "ID" is the 1, 2, 3... identification 
        number. "CHR" is chromosome. "START" is the start position of the marker 
        block, i.e. the position of the first marker in this marker block. "END"
        is the end position of the marker block, i.e. the position of the last
        marker in the marker block. "N.MARKER" is the number of markers in the
        marker block.
    }
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{
  missing value is not allowed so far. Marker data can be imputed by function
  impute.geno in this package, fill.geno in package qtl or other methods.
}

\seealso{ \code{\link{nn.hclust}} }
\examples{
data(yeastMarkers)
mm = data.matrix(yeastMarkers[,(4:43)])
im = yeastMarkers[,1:3]

# drop markers with too many missing values 
# and drop individuals with too many missing values
mmKeep = dropNA(mm)
mm = mmKeep$data
im = im[mmKeep$rowKeep,]

# impute missing value in genotype data simply by nearest neighbor
mm  = impute.geno(mm, im)

# generate marker blocks
mb = get.mb(mm, im, 2.0)
}
\keyword{ methods }

