\name{get.lod}
\alias{get.lod}
\title{ calculate LOD score }
\description{
    Calculate of LOD score of the anova model, based on result from anova1 or 
    anova 2.
}
\usage{
get.lod(mse, geneID, me)
}
\arguments{
  \item{mse}{ maximum likelihood estimation of mse, a vector from result of 
    anova1 or anova2
  }
  \item{geneID}{ corresponding gene ID
  }
  \item{me}{ matrix of gene expresison data, Only numerical values allowed.
  }
}
\details{
  this function calculate the LOD score of ANOVA model. 
  LOD = likelihood1 /likelihood0
  likelihood1 = likelihood that gene expression follow the given ANOVA model
  likelihood0 = likelihood that gene expression follow the mean value only model
}
\value{
    a vector of LOD scores with the same length as mse and gneeID. 
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ 
    MSE in ANOVA model is SSE/(n-n.parameter), while MSE of maximum 
    likelihood estimation is SSE/n, where n is number of observations.
}

\seealso{ \code{\link{anova1}} \code{\link{anova2}} }
\examples{
data(yeastExpressions)
data(yeastMarkers)

me = data.matrix(yeastExpressions[1:1000,(3:42)])
mm = data.matrix(yeastMarkers[,(4:43)])
ie = yeastExpressions[1:1000,1:2]
im = yeastMarkers[,1:3]

# drop rows or columns with too many missing values
meKeep = dropNA(me);
mmKeep = dropNA(mm);
me = me[meKeep$rowKeep, intersect(meKeep$colKeep, mmKeep$colKeep)]
mm = mm[mmKeep$rowKeep, intersect(meKeep$colKeep, mmKeep$colKeep)]
ie = ie[meKeep$rowKeep,]
im = im[mmKeep$rowKeep,]

# impute missing value in gene expression data by 10 nearest neighbor
library(impute)
me = impute.knn(me, k=10, rowmax=0.6, colmax=0.8, maxp=nrow(me));

# impute missing value in genotype data simply by nearest neighbor
mm  = impute.geno(mm, im)

# generate marker blocks
mb = get.mb(mm, im, 2.0)
dim(mm)
dim(mb$data)

cut = 1e-3
a = anova1(me, mb$data, cut, "1g1mbAnova.txt")

# read in the result of one gene one marker block analysis
# calculate lod scores
aa = read.table("1g1mbAnova.txt", header=TRUE, sep="\t")
lods = get.lod(aa$MSE_MLE, aa$GENE_ID, me)

}
\keyword{ methods }

