\name{anova2p}
\alias{anova2p}
\title{ two way ANOVA analysis }
\description{
    ANOVA analysis for one continuous response and two factorial predictors.
    It is pretty fast in handling a large number of responses and predictors.
}
\usage{
anova2p(me, mm, cuts, cuts.direction, p12cuts, nper, minLen = 5, 
    binary.marker=FALSE, show.permutations=FALSE)
}
\arguments{
  \item{me}{ matrix of responses, each row is one response. This matrix is gene
   expression data in eQTL analysis. Only numerical values and NA allowed.
  }
  \item{mm}{ matrix of predictors, each row is one predictor. This matrix is
   marker genotype data in eQTL analysis. Only values -1, 0, 1 and NA allowed. 
  }
  \item{cuts}{ a vector of four cut-off values. Sequentially, ANOVA P-value
    cut-offs of first main effect, second main effect, interaction effect
    and cut-off of Chi-square test P-value that test the independence of the
    two markers.
  }
  \item{cuts.direction}{ a vector of length 4, which indicates the direction of 
    in-equality as we filter out result with p-value cutoff in the argument 
    cuts. Taking only two values, -1 or 1. -1 means``smaller than'' and 1 
    means``bigger than''. For example, if cuts = c(0.01, 0.01. 0.001, 0.05) and 
    cuts.direction = c(1, 1, -1, 1), the filtering rule is p-value of two main 
    effects are bigger than 0.01, p-value of interaction effect is smaller than 
    0.001, and p-value of chi-square test is bigger than 0.05.
  }
  \item{p12cuts}{ the cutoffs of interaction effect where we calculate FDR. For 
    each cutoff, FDR is calculated as the ratio between the expected number of 
    false positives and the total number of linkages detected  }
  \item{nper}{ the total number of permuations }
  \item{minLen}{ minimum number of observations in one factor level. It must 
    be positive integer. Cases that there is no observation in any one factor
    level(the model matrix is singlar) are skipped. }
  \item{binary.marker}{ whether the genotype of one marker is binary or not }
  \item{show.permutations}{ whether show the permutations }
}
\details{
    execute anova2 for original data and then for permuted data. 
}
\value{
    a data frame indicating number of discovery (D), number of false discovery (FD) and false discovery rate (FDR).
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }

\seealso{ \code{\link{anova2}} }
\examples{
data(yeast.me)
data(yeast.mm)

me = yeast.me
mm = yeast.mm
cuts = c(1e-2, 1e-2, 1e-3, 1e-5)
cuts.direction = c(1, 1, -1, 1)
p12cuts = c(1e-4, 1e-5, 1e-6, 1e-7, 1e-8)
nper = 3
minLen = 5
binary.marker = TRUE
show.permutations = TRUE
a = anova2p(me, mm, cuts, cuts.direction, p12cuts, nper, minLen, binary.marker, show.permutations)

}
\keyword{ methods }

