"nn.hclust" <- 
function(m, method="complete", dis="manhattan"){
    
    # get distance of two clusters, complete linkage and manhattan distance
    get.dist <- function(data, idx1, idx2){
        d.max = 0.0;
        for(i in idx1){
            for(j in idx2){
                d.tmp = sum(abs(data[i,] - data[j,]));
                if(d.tmp > d.max){ d.max = d.tmp; }
            }
        }
        d.max
    }

    # number of rows in data matrix
    n = nrow(m);
    
    # a list eventually have n-1 items that store the indices of original items 
    # involved in i-th merge
    idxes  = list();
    
    # a matrix of size (n-1)*2, which store the pair of objects merged in i-th 
    # step, negative number indicate one original item, positive number indicate 
    # one cluster
    merge  = matrix(NA, nrow=n-1, ncol=2);
    
    # a vector of size (n-1) that stores the distance between the pair of 
    # objects merged in i-th step
    height = numeric(n-1);
    
    # a vector whose length decreases during clustering. It label the items 
    # remained to be clustered, negative number indicate one original item
    # positive number indicate one cluster
    label  = -(1:nrow(m));
    
    # a vector indicate distances between adjacent objects, its length decreases 
    # during clustering
    dist.v = numeric(n-1);
    for(i in 1:(n-1)){
        dist.v[i] = sum(abs(m[i,] - m[i+1,]));
    }
    
    for(i in 1:(n-1)){
        idx  = numeric(0);
        tidx = numeric(0);
        
        # merge nearest adjacent neighbors
        dmin = min(dist.v);
        if(is.na(dmin)){stop("distance is NA\n");}
        height[i] = dmin;
        imin = (1:(n-i))[dist.v==dmin][1];
        merge[i,] = label[imin:(imin+1)];
        
        # update idxes: the index of two group of original items involved in 
        # i-th step merge
        t = label[imin];
        if(t < 0){ idx = -t; }else{ idx = idxes[[t]]; }
        t = label[imin+1];
        if(t < 0){ idx = c(idx, -t); }else{ idx = c(idx, idxes[[t]]); }
        idxes[[i]] = idx;
        
        # update label, the length of label becomes (n-i)
        tlabel = numeric(n-i);
        if(imin > 1){
            tlabel[1:(imin-1)] = label[1:(imin-1)];
        }
        if(imin < n-i){
            tlabel[(imin+1):(n-i)] = label[(imin+2):(n-i+1)];
        }
        tlabel[imin]=i;
        label = tlabel;
        
        # update dist.v, the length of dist.v becomes (n-i-1)
        td = numeric(n-i-1);
        if(imin > 2){
            td[1:(imin-2)] = dist.v[1:(imin-2)];
        }
        if(imin < n-i-1){
            td[(imin+1):(n-i-1)] = dist.v[(imin+2):(n-i)];
        }
        if(imin > 1){
            t = label[imin-1];
            if(t > 0){tidx = idxes[[t]];}else{tidx = -t; };
            td[imin-1] = get.dist(m, tidx, idx);
        }
        if(imin < n-i){
            t = label[imin+1];
            if(t > 0){tidx = idxes[[t]];}else{tidx = -t; };
            td[imin] = get.dist(m, tidx, idx);
        }
        dist.v = td;
    }
    result = list(merge = merge, height = height);
    result
}
