"impute.geno" <-
function(mm, im){
    if(nrow(mm) != nrow(im)){
        stop("length of mm and im doesn't match!\n");
    }
    
    if(!any(names(im) == "CHR")){
        stop("there should be at least one column named 'CHR' in 
          gene information matrix ie");
    }
    if(!any(names(im) == "POSITION")){
        stop("there should be at least one column named 'POSITION' in 
          marker information matrix im");
    }
    
    o = order(im$CHR, im$POSITION);
    if(any(im$CHR != im$CHR[o]) || any(im$POSITION != im$POSITION[o])){
        stop("markers are not ordered by chromosome location\n")
    }
    
    chr = im$CHR;
    pos = im$POS;
    uchr = unique(chr);
    for(j in 1:ncol(mm)){
        mj = mm[,j];
        for(c in uchr){
            mj.c  = mj[chr==c];
            pos.c = pos[chr==c];
            mj.na = mj.c[is.na(mj.c)];
            mj.a  = mj.c[!is.na(mj.c)];
            pos.na= pos.c[is.na(mj.c)];
            pos.a = pos.c[!is.na(mj.c)];
            for(i in 1:length(mj.na)){
                mj.na[i] = mj.a[which.min(abs(pos.na[i] - pos.a))];
            }
            mj.c[is.na(mj.c)] = mj.na;
            mj[chr==c] = mj.c;
        }
        mm[,j] = mj;
    }
    mm
}
