"get.mb" <- 
function(mm, im, cut, method="complete", dis="manhattan"){
    if(nrow(mm) != nrow(im)){
        stop("length of mm and im doesn't match!\n");
    }
    
    if(!any(names(im) == "CHR")){
        stop("there should be at least one column named 'CHR' in 
          gene information matrix ie");
    }
    if(!any(names(im) == "POSITION")){
        stop("there should be at least one column named 'POSITION' in 
          marker information matrix im");
    }
    
    o = order(im$CHR, im$POSITION);
    if(any(im$CHR != im$CHR[o]) || any(im$POSITION != im$POSITION[o])){
        stop("markers are not ordered by chromosome location\n")
    }
    
    chrs = sort(unique(im$CHR));
    mb.data = numeric(0);
    mb.info = numeric(0);
    
    for(chr in chrs){
        cat(sprintf("chromosme %s \n", chr));
        m.chr  = mm[im$CHR == chr,];
        p.chr  = im$POS[im$CHR == chr];
        hc     = nn.hclust(m.chr);
        groups = cutree(hc, h=cut);
        blocks = unique(groups);
        total  = length(blocks);
        mb.chr = matrix(NA, nrow=total, ncol=ncol(mm));
        chrom  = rep(chr, total);
        start  = numeric(total);
        end    = numeric(total);
        nmarker= numeric(total);
        for(b in blocks){
            m.bi = m.chr[groups==b,];
            p.bi = p.chr[groups==b];
            
            if(is.vector(m.bi)){
                nmarker[b] = 1;
            }else{
                nmarker[b] = nrow(m.bi);
            }
            
            start[b] = min(p.bi);
            end[b]   = max(p.bi);
            
            if(is.vector(m.bi)){
                mb.chr[b,] = m.bi;
            }else if(nrow(m.bi)==2){
                mb.chr[b,] = m.bi[1,];
            }else{
                m.center = apply(m.bi, 2, mean);
                dists = numeric(nrow(m.bi));
                for(c in 1:nrow(m.bi)){
                    dists[c] = sum(abs(m.bi[c,]-m.center));
                }
                choose = (1:nrow(m.bi))[dists==min(dists)][1];
                mb.chr[b,] = m.bi[choose,];
            }
        }
        
        mb.info = rbind(mb.info, cbind(chrom, start, end, nmarker));
        mb.data = rbind(mb.data, mb.chr);
    }
    
    mb.info = data.frame(1:nrow(mb.info), mb.info);
    names(mb.info) = c("ID", "CHR", "START", "END", "N.MARKER");
    result = list(data=mb.data, info=mb.info);
    result
}
