"get.lod" <-
function(mse, geneID, me){
    if(length(mse) != length(geneID)){
        stop("length of mse and geneID are different!");
    }

    if(is.vector(me)){
        ncol.me = length(me)
        nrow.me = 1
    }else{
        ncol.me = ncol(me)
        nrow.me = nrow(me)
    }

    dims = numeric(3);
    dims[1] = length(mse);
    dims[2] = nrow.me;
    dims[3] = ncol.me;
    
    me.na = is.na(me);
    len.nna = function(v){ length(na.omit(v)) }
    me.len  = apply(me, 1, len.nna);
    me[me.na] = 0;

    lods = numeric(dims[1]);
    Z = .C("get_lod", as.integer(dims), as.double(mse), as.integer(geneID), 
        as.double(me), as.integer(!me.na), as.integer(me.len), as.double(lods), 
        PACKAGE="anovaEQTL");

    me[me.na] = NA;

    Z[[length(Z)]]
}
