"dropNA" <-
function(data, row.na.prop=0.2, col.na.prop=0.2){
    if(row.na.prop > 1 || row.na.prop < 0 ){
        stop("row.na.prop should be between 0 and 1\n");
    }
    if(col.na.prop > 1 || col.na.prop < 0 ){
        stop("col.na.prop should be between 0 and 1\n");
    }

    "count.NA" <- function(v){ length(which(is.na(v))) }

    row.NA = apply(data, 1, count.NA);
    col.NA = apply(data, 2, count.NA);
    row.keep = which(row.NA <= ncol(data)*row.na.prop);
    col.keep = which(col.NA <= nrow(data)*col.na.prop);
    cat(sprintf("%d rows are dropped\n", nrow(data) - length(row.keep)));
    cat(sprintf("%d columns are dropped\n", ncol(data) - length(col.keep)));
    new.data = data[row.keep, col.keep];
    all = list(data=new.data, rowKeep=row.keep, colKeep=col.keep)
    all
}
