"anova2p" <-
function(me, mm, cuts, cuts.direction, p12cuts, nper, minLen = 5, 
    binary.marker=FALSE, show.permutations=FALSE)
{
    if(ncol(mm) != ncol(me)){
        stop("number of column of mm and me are different!");
    }
    if(!(minLen%%1==0 && minLen > 0)){
        stop("minLen must be positive integers\n");
    }
    
    p12cuts = sort(p12cuts)
    
    if(p12cuts[1] > cuts[3]){
        stop("the minimum of p12cuts should be smaller than cuts[3]\n")
    }
    
    cat("doing chisq-test of markers\n");
    mp = chisqAll(mm, binary.marker, minLen);
    
    dims = numeric(5);
    dims[1] = nrow(me);
    dims[2] = nrow(mm);
    dims[3] = ncol(me);
    dims[4] = length(p12cuts);
    dims[5] = nper;
    
    ## number of discovery and false discovery
    Ds = FDs = numeric(dims[4]);
    
    succeed = 0;
    
    cat("doing ANOVA calculation\n")
    Z = .C("anova2p", as.integer(dims), as.double(me), as.double(mm),
           as.double(mp), as.double(cuts), as.double(cuts.direction), 
           as.double(p12cuts), D=as.double(Ds), FD=as.double(FDs), 
           as.integer(binary.marker), as.integer(show.permutations),
           as.integer(succeed), PACKAGE="anovaEQTL");
           
    FDR = Z$FD/Z$D
    
    dfs = data.frame(p=p12cuts, D=Z$D, FD=Z$FD, FDR=FDR)
    dfs
}

