"anova2" <-
function(me, mm, cuts, cuts.direction, output, minLen = 5, binary.marker=FALSE, coef=FALSE){
    if(ncol(mm) != ncol(me)){
        stop("number of column of mm and me are different!");
    }
    if(!(minLen%%1==0 && minLen > 0)){
        stop("minLen must be positive integers\n");
    }
    
    cat("doing chisq-test of markers\n");
    mp = chisqAll(mm, binary.marker, minLen);
    cat("\n");
    
    dims = numeric(3);
    dims[1] = nrow(me);
    dims[2] = nrow(mm);
    dims[3] = ncol(me);
    succeed = 0;
    cat("doing ANOVA calculation\n")
    Z = .C("anova2", as.integer(dims), as.double(me), as.double(mm),
           as.double(mp), as.double(cuts), as.double(cuts.direction), 
           as.character(output), as.integer(coef), as.integer(binary.marker),
           as.integer(succeed), PACKAGE="anovaEQTL");
    Z[[length(Z)]]
}
