\name{nn.hclust}
\alias{nn.hclust}
\title{ nearest neighbor hierarchical clustering }
\description{
    A modified hierarchical clustering. N objects to be clustered are first 
    ordered. And then in each step, only the adjacent objects are clustered 
    together based on the distances between adjacent objects.
}
\usage{
nn.hclust(m, method="complete", dis="manhattan")
}
\arguments{
  \item{m}{ data matrix, each row represent one object to be clustered }
  \item{method}{ the agglomeration method to be used. Now only "complete" 
    is supported }
  \item{dis}{ the distance measure to be used. Now only "manhattan" 
    is supported }
}
\details{
  This algorithm is specially designed for analysis of genotype data in EQTL
  analysis. Genetic markers can be ordered by chromosome location. Neighboring
  markers tend to have very high correlation and some are even identical, so
  clustering them together can effectively reduce computation burden without
  losing much information.
}
\value{
    a list including two components, merge and height. These two components
    are the same as the corresponding components of return value from function
    'hclust' so that 'cutree' can be used to cut the resulting hierarchical
    tree, as it does for result of hclust. 
    \item{merge}{
        an n-1 by 2 matrix. Row i of 'merge' is a pair of number indicating the
        objects merged in step i of the clustering, negative number -j indicate 
        one original item, positive number j indicate one cluster formed in j-th 
        step of the algorithm.
    }
    \item{height}{
        a vector of length n-1. i-th value is the distance between two objects 
        clustered at i-th step of the algorithm.
    }
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{
  If the markers have only binary data (as in haploid organism such as yeast).
  Distance between two markers are well defined. If the markers have three
  levels (as in diploid organism such as mouse, human), we recommend to code
  two homozygous genotypes as -1 and 1 and code the heterozygous genotype as 0.
}

\seealso{ \code{\link{get.mb}} }
\examples{
data(yeastMarkers)
mm = data.matrix(yeastMarkers[,(4:43)])
im = yeastMarkers[,1:3]

# drop markers with too many missing values 
# and drop individuals with too many missing values
mmKeep = dropNA(mm)
mm = mmKeep$data
im = im[mmKeep$rowKeep,]

# impute missing value in genotype data simply by nearest neighbor
mm  = impute.geno(mm, im)

# generate marker blocks
mb = nn.hclust(mm[im$CHR==1,])

}
\keyword{ methods }

