\name{dropNA}
\alias{dropNA}
\title{ drop observations with too many missing values }
\description{
    given a data matrix, the function will drop those rows with more missing 
    values than a given threshold.
}
\usage{
dropNA(data, row.na.prop=0.2, col.na.prop=0.2)
}
\arguments{
  \item{data}{ data matrix
  }
  \item{row.na.prop}{ the maximum proportion of NA values allowed in one row.
    All the rows with more missing proportion more than \code{row.na.prop}
    are dropped
  }
  \item{col.na.prop}{ the maximum proportion of NA values allowed in one column.
    All the columns with more missing proportion more than \code{col.na.prop}
    are dropped
  }
}
\details{
}
\value{
  a list including three components:
  \item{data}{ data matrix after dropping those rows and columns with too many
    missing value
  }
  \item{rowKeep}{ indices of rows kept in the data matrix }
  \item{colKeep}{ indices of columns kept in the data matrix }
  
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ 
}

\seealso{  }
\examples{
data(yeastExpressions)
me = data.matrix(yeastExpressions[1:1000,(3:42)])
me = dropNA(me, 0.25);
}
\keyword{ methods }

