\name{chisqAll}
\alias{chisqAll}
\title{ chi-square test for all the marker pairs }
\description{
  take marker data matrix as input,  carry out chi-square test for all the marker pairs, and output a p-value matrix.
}
\usage{
chisqAll(mm, binary, minLen)
}
\arguments{
  \item{mm}{ the matrix of marker data }
  \item{binary}{ whether the marker are binary data }
  \item{minLen}{ minimum number of observations in one factor level. It must 
    be positive integer }
}

\details{
}

\value{
    a square matrix, the [i,j] element of the matrix is the chi-square p-value between marker i and marker j. 
}
\references{  }
\author{ Wei Sun sunwei@stat.ucla.edu }
\note{ 
    implemented in C and implemented specifically for marker data to increase the speed
}
\seealso{  }
\examples{
data(yeast.mm)
mm = yeast.mm
mp = chisqAll(mm, TRUE, 5)
}
\keyword{ methods }
