"plot.1g2m" <-
function(me, mm, ie, im, m1.id, m2.id, g.id){

    mb1.str = sprintf("M%d", m1.id);
    mb2.str = sprintf("M%d", m2.id);
    mb12.str = sprintf("M%d:M%d", m1.id, m2.id);

    if(!any(names(ie) == "ID")){
        stop("there should be at least one column named 'ID' in 
          gene information matrix ie");
    }
    if(!any(names(im) == "ID")){
        stop("there should be at least one column named 'ID' in 
          marker information matrix im");
    }
        
    m1.i = im[m1.id,];
    m2.i = im[m2.id,];
    g.i  = ie[g.id,];
    
    m1.d = mm[m1.id,];
    m2.d = mm[m2.id,];
    g.d  = me[g.id,];
    
    m1 = as.factor(m1.d);
    m2 = as.factor(m2.d);
    
    p.chi = chisq.test(m1,m2)$p.value;
    # if(p.chi < 1e-5){
    #   war = sprintf("two markers are similar, chisq.test p-value=%.2e", p.chi)
    #   warning(war);
    # }
    
    l1 = lm(g.d~m1*m2);
    an = anova(l1);
    print.anova(an)
    l0 = lm(g.d~1);
    logL0 = logLik(l0)/log(10);
    logL1 = logLik(l1)/log(10);
    LOD   = as.numeric(logL1 - logL0);
    cat(gettextf("\nlogL0=%.4f, logL1=%.4f, LOD=%.4f\n",logL0,logL1,LOD));
    
    quartz(width=10, height=5)
    par(mfrow=c(1,2))

    m.levels = unique(m1.d);
    m.levels = sort(m.levels);
    n.levels = length(m.levels);

    mc = as.factor(m1.d + n.levels*m2.d)
    plot(mc, g.d, xaxt="n")
    mtext(mb1.str, side = 1, line = 1, at = 0)
    
    mtext(rep(m.levels, n.levels), side = 1, line = 1, at = 1:n.levels^2)
    mtext(mb2.str, side = 1, line = 3, at = 0)
    mtext(rep(m.levels, each=n.levels), side = 1, line = 3, at = 1:n.levels^2)
    count = table(mc)
    xpos = as.numeric(names(count))
    xpos = xpos - min(xpos) + 1;
    mtext(count, side = 3, line = 1, at = xpos)
    
    par(mar=rep(0.1,4));
    plot(c(0,1), c(0,1), type="n", axes=FALSE, xlab="", ylab="");
    if(any(names(g.i) == "GENE_SYM") && !is.na(g.i$GENE_SYM)){
        gene.sym = g.i$GENE_SYM;
    } else if(any(names(g.i) == "YORF") && !is.na(g.i$YORF)){
        gene.sym = g.i$YORF;
    }else{
        gene.sym = sprintf("GENE_%D",g.i$ID);
    }
    g.sym = as.character(gene.sym);
    
    title = sprintf("gene %s vs. %s and %s", g.sym, mb1.str, mb2.str);
    text (0.5, 0.9, title, cex = 1.5);
    anovaPs = signif(an,3)[,5];
    anovaPs = as.character(anovaPs[1:3]);
    ps = c("ANOVA P-value", anovaPs);
    ts = c("ANOVA Effects", mb1.str, mb2.str, mb12.str);
    xs = c(0.05, 0.4, 0.6, 0.8);
    text(xs, 0.6, ts, cex=1.2, pos=4);
    text(xs, 0.52, ps, cex=1.2, pos=4);
    text(0.05, 0.3, "LOD Score", cex=1.2, pos=4);
    text(0.4,  0.3, round(LOD,2), cex=1.2, pos=4);
}
