"anova1" <-
function(me, mm, cut, output, minLen=5){
    if(is.vector(me)){
        ncol.me = length(me)
        nrow.me = 1
    }else{
        ncol.me = ncol(me)
        nrow.me = nrow(me)
    }

    if(is.vector(mm)){
        ncol.mm = length(mm)
        nrow.mm = 1
    }else{
        ncol.mm = ncol(mm)
        nrow.mm = nrow(mm)
    }

    if(ncol.mm != ncol.me){
        stop("number of column of mm and me are different!");
    }
    if(!(minLen%%1==0 && minLen >= 0)){
        stop("minLen must be non-negative integer\n");
    }

    dims = numeric(3);
    dims[1] = nrow.me;
    dims[2] = nrow.mm;
    dims[3] = ncol.me;
    succeed = 0;
    
    me.na = is.na(me);
    mm.na = is.na(mm);
    
    me[me.na] = 0;
    mm[mm.na] = 0;
    
    Z = .C("anova1", as.integer(dims), as.double(me), as.double(mm),
            as.integer(!me.na), as.integer(!mm.na), as.double(cut), 
            as.integer(minLen), as.character(output), as.integer(succeed), 
            PACKAGE="anovaEQTL");
    
    me[me.na] = NA;
    mm[mm.na] = NA;
    
    Z[[length(Z)]]
}
