skeletonPENstable <-
function(suffStat, indepTest, p, alpha, verbose = FALSE,
edgeWeights, fixedEdges = NULL, NAdelete = FALSE) {
    
    ## Purpose: Perform undirected part of PC-Algorithm, i.e.,
    ## estimate skeleton of DAG given data
    ## ----------------------------------------------------------------------
    ## Arguments:
    ## - dm: Data matrix (rows: samples, cols: nodes)
    ## - C: correlation matrix (only for continuous)
    ## - n: sample size
    ## - p: number of variables !! NEU
    ## - alpha: Significance level of individual partial correlation tests
    ## - corMethod: "standard" or "Qn" for standard or robust correlation
    ##              estimation
    ## - edgeWeights: the weight or adjacency matrix of the graph from which the algorithm
    ## - fixedEdges: Edges marked here are not changed (logical)
    ## - datatype: distinguish between discrete and continuous data
    ## - NAdelete: delete edge if pval=NA (for discrete data)
    ## - m.max: maximal size of conditioning set
    ## - gTrue: Graph object of true DAG
    ## ----------------------------------------------------------------------
    ## Value:
    ## - G, sepset, pMax, ord, n.edgetests
    ## ----------------------------------------------------------------------
    ## Author: Markus Kalisch, Date: 09.12.2009
    ##         Wei Sun modified on 09.02.2011
    ##         Min Jin Ha modified on 04.28.2012
    ##         Min Jin Ha modified for stability on 12.05.2012
    
    stopifnot((p = as.integer(p)) >= 2)
    cl = match.call()
    ## start skeleton
    
    fixedGaps = (edgeWeights== 0)  
    ## fixed gaps
    if (is.null(edgeWeights)) {
        stop("no edgeWeights")
    } else {
        if (!identical(dim(fixedGaps),c(p,p))) {
            stop("Dimensions of the dataset and fixedGaps do not agree.")
        } else {
            if (!all(fixedGaps == t(fixedGaps)))
            stop("fixedGaps must be symmetric")
            G = !fixedGaps
        }
    } ## if(is.null(G))
    
    m.max = max(rowSums(G)) ####### modified!!!
    
    ## fixed edges
    if (is.null(fixedEdges)) {
        fixedEdges = matrix(FALSE, p,p)
    } else {
        if (!(identical(dim(fixedEdges),c(p,p))))
        stop("Dimensions of the dataset and fixedEdges do not agree.")
        if (fixedEdges != t(fixedEdges))
        stop("fixedEdges must be symmetric")
    }
    
    seq_p  = seq_len(p)
    sepset = pl = vector("list",p)
    for (i in seq_p) sepset[[i]] = pl
    # ================================= #
    # Initialize sepset for gaps in GGM
    # ================================= #
    if (sum(G)>0) {
        w.upper = which(upper.tri(diag(p)),arr.ind=T)
        ind = w.upper[G[w.upper],]
        # For all gaps, find pattern x-z-y, z can be multiple
        for (i in 1:dim(ind)[1]) {
            x <- ind[i,1]
            y <- ind[i,2] 
            pval <- indepTest(x,y,integer(0),suffStat)
            if (verbose) cat("Marginal test",x,"and",y,"pvalue = ",pval,"\n")
            if (pval>=alpha) {
                sepset[[x]][[y]]=sepset[[y]][[x]] = integer(0)
            }else {
                sepset[[x]][[y]] = setdiff(seq_p,c(x,y))
                isect    = (G[x,] & G[y,]) # common vertices (co-parents & co-child)
                if (sum(isect)> 0) {
                    allZ = seq_p[isect]
                    for (z in allZ) {
                        pval = indepTest(x,y,z,suffStat)
                        if (verbose) cat("text",x,"and",y,"with commone vertices",allZ,"pvalue = ",pval,"\n")
                        if (is.na(pval)) pval <- if (NAdelete) {1}else {0} 
                        if (pval<alpha) {
                            sepset[[x]][[y]] =sepset[[y]][[x]] = setdiff(sepset[[x]][[y]],z) 
                        }
                    }
                }
            }
        }
    }     
   
    ## save maximal p value
    pMax        = matrix(-Inf, p,p)
    diag(pMax)  = 1
    
    done        = FALSE
    ord         = -1L
    n.edgetests = numeric(1) # final length = max {ord} + 1
    n.edgerms   = numeric(1) # final length = max {ord} + 1
    
    while (any(G) && ord <= m.max) {
        ord1 = ord+2L
        n.edgetests[ord1] = 0
        n.edgerms[ord1]   = 0
        
        tmpG=G
        w.lower= which(lower.tri(tmpG),arr.ind=T)
        tmpG[w.lower] = 0
        ind = matrix(which(tmpG!=0,arr.ind=T),ncol=2) # for unique edge        
        remainingEdgeTests = nrow(ind)
        
        aG = G # modified for stability
        for (i in 1:remainingEdgeTests) {
            if(verbose) { if(i%%100==0) cat("|i=",i,"|iMax=",nrow(ind),"\n") }
            x = ind[i,1]
            y = ind[i,2]
            
            if (G[y,x] && !fixedEdges[y,x]) {
                nbrsUnion = (aG[,x]|aG[,y]) # modifed and stability
                nbrsUnion[x] = FALSE
                nbrsUnion[y] = FALSE
                
                nbrsIsect    = (aG[,x] & aG[,y]) # stability
                nbrsIsect[x] = FALSE
                nbrsIsect[y] = FALSE
                
                
                #### modified 03/30/2013 ####
                if (sum(nbrsIsect) != 0) {
                    Isect = seq_p[nbrsIsect]
                    nbrsDec = vector("list",length(Isect))
                    for (sec in 1:length(Isect)) { 
                        Gsub = aG # stability
                        Gsub[,c(x,y)] = Gsub[c(x,y),] = FALSE
                        nbrsDec[[sec]] = (connectedComp(Gsub,Isect[sec]) & nbrsUnion)
                    }
                }else{nbrsDec = vector("list",1)
                    nbrsDec[[1]] = nbrsIsect
                }
                
                for (id.dec in 1:length(nbrsDec)) {
                    nbrsdec = nbrsDec[[id.dec]]
                    nbrs         = seq_p[nbrsUnion]
                    nbrs2rm      = seq_p[nbrsdec]
                    length_nbrs  = length(nbrs2rm)
                    
                    if (length_nbrs >= ord) {
                        if (length_nbrs > ord) done = FALSE
                        
                        if(ord < 0){
                            nbrs2test = numeric(0)
                        }else if(ord == 0){
                            nbrs2test = nbrs
                        }else{
                            S = seq_len(ord)
                            nbrs2test = setdiff(nbrs, nbrs2rm[S])
                        }
                        
                        repeat { ## condition w.r.to all  nbrs[-S] of size 'ord'
                            n.edgetests[ord1] = n.edgetests[ord1]+1
                            
                            pval = indepTest(x,y, nbrs2test, suffStat)
                            
                            if (verbose) {
                                cat("x=",x," y=",y," nbrs=", nbrs," nbrs2rm=",nbrs2rm,
                                " nbrs2test=",nbrs2test,": pval =",pval,"\n")
                            }
                            
                            if (is.na(pval)) {
                                print("pval is NA")
                                pval = if(NAdelete) 1 else 0
                            }
                            if (pval > pMax[x,y]) pMax[x,y] = pval
                            
                            if(pval >= alpha) { # independent
                                n.edgerms[ord1]  = n.edgerms[ord1]+1
                                G[x,y] = G[y,x]  = FALSE
                                sepset[[x]][[y]] = nbrs2test
                                
                                break
                            } else if(ord <= 0){
                                break
                            }else {
                                nextSet = getNextSet(length_nbrs, ord, S)
                                if(nextSet$wasLast) { break }
                                S = nextSet$nextSet
                            }
                        } ## repeat
                        
                    } ## if (length_nbrs >= ord)
                } ## for (id.dec in 1:length(nbrsDec))
            } ## if (G[y,x] && !fixedEdges[y,x]) 
            
        } ## for(i in 1:remainingEdgeTests)
        ord = ord + 1
    } ## while
    
    for (i in 1:(p-1)) {
        for (j in 2:p) {
            pMax[i,j] = pMax[j,i] = max(pMax[i,j],pMax[j,i])
        } ## for (j in 2:p)
    } ## for (i in 1:(p-1))
    
    ## transform matrix to graph object :
    nnms = as.character(seq_p)
    Gobject =
    if (sum(G) == 0) {
        new("graphNEL", nodes = nnms)
    } else {
        colnames(G) = rownames(G) = nnms
        as(G,"graphNEL")
    }
    
    
    #cat("\n", n.edgerms, "\n")
    
    ## final object
    new("pcAlgo",
    graph = Gobject,
    call = cl, n = integer(0), max.ord = as.integer(ord-1),
    n.edgetests = n.edgetests, sepset = sepset,
    pMax = pMax, zMin = matrix(NA,1,1))
    
}
