\name{skeleton.stable}
\alias{skeleton.stable}
\title{Estimate the skeleton of a DAG using the PC-stable Algorithm
}
\description{
	  Estimate the \dQuote{skeleton} of a directed
  acyclic graph (DAG) from observational data,
  using the PC-stable algorithm.

}
\usage{
skeleton.stable(suffStat, indepTest, p, alpha, verbose = FALSE, fixedGaps = NULL, fixedEdges = NULL, NAdelete = TRUE, m.max = Inf)
}
\arguments{
  \item{suffStat}{Sufficient statistics: List containing all necessary
    elements for the conditional independence decisions in the
    function \code{indepTest}.}
  \item{indepTest}{Predefined function for testing conditional independence. The
    function is internally called as \code{indepTest(x,y,S,suffStat)}, and
    tests conditional independence of \code{x} and \code{y} given
    \code{S}. Here, \code{x} and \code{y} are variables, and \code{S} is
    a (possibly empty) vector of variables (all variables are denoted
    by their column numbers
    in the adjacency matrix). \code{suffStat} is a list containing
    all relevant elements for the conditional independence
    decisions. The return value of \code{indepTest} is the p-value of
    the test for conditional independence.}
  \item{p}{Number of variables.}
  \item{alpha}{Significance level for the individual conditional
    independence tests.}
  \item{verbose}{If \code{TRUE}, detailed output is provided.}
  \item{fixedGaps}{A logical matrix of dimension p*p. If entry
    \code{[i,j]} or \code{[j,i]} (or both) are TRUE, the edge i-j is
    removed before starting the algorithm. Therefore, this edge is
    guaranteed to be absent in the resulting graph.}
  \item{fixedEdges}{A logical matrix of dimension p*p. If entry
    \code{[i,j]} or \code{[j,i]} (or both) are TRUE, the edge i-j is
    never considered for removal. Therefore, this edge is
    guaranteed to be present in the resulting graph.}
  \item{NAdelete}{If indepTest returns \code{NA} and this option is
    \code{TRUE}, the corresponding edge is deleted. If this option is
    \code{FALSE}, the edge is not deleted.}
  \item{m.max}{Maximal size of the conditioning sets that are considered in the
    conditional independence tests.}
}
\details{
This function is a modification of \code{skeleton} function in \code{pcalg} package for order-independent estimation.
}
\value{An object of \code{\link{class}} \code{"pcAlgo"} (see
  \code{\linkS4class{pcAlgo}}) containing an estimate of the skeleton of
  the underlying DAG,
  the conditioning sets that led to edge removals (sepset) and several
  other parameters.
}
\references{
     Colombo, D. and Maathuis, M. (2012). A modification of the pc algorithm yielding order-independent skeletons. arXiv preprint arXiv:1211.3295.
}
\author{
Min Jin Ha (\email{minjin.ha@gmail.com})
}
\examples{
alpha = 0.01
p = 100 # number of vertices
e = 1 # one edge added in each time step
n = 30 # sample size
simul=simul.BA(p,e,n)

dat = simul$X
indepTest = gaussCItest
suffStat  = list(C = cor(dat), n = n) 

fit.pc.stable = skeleton.stable(suffStat, indepTest, p, alpha)

}

