ne.PEN <-
function(dat,nlambda,ntau,V,order=FALSE,verbose=FALSE)
{
    ## Purpose: Fitting Gaussian Graphical Model using log penalty
    ## ----------------------------------------------------------------------
    ## Arguments:
    ## - dat : n x p data matrix with n (# of sample) and p (# of variables)
    ## - nLambda : # of candidate lambda as a tuning parameter of Log penalty
    ## - nTau : # of candidate tau as a tuning parameter of Log penalty
    ## - V : the set of vertices which neighbors are estimated
    ## - order : if TURE covariate order are in the order of marginal correlation
    ## ----------------------------------------------------------------------
    ## Author: Min Jin Ha, Date: 18 March 2013
    
    stopifnot(is.matrix(dat),nrow(dat)>1,ncol(dat)>1)
    p = ncol(dat)
    n = nrow(dat)
    coefNI = matrix(0, nrow=p, ncol=length(V))
    
    for (i in 1:length(V)) {
        v = V[i]  
        if (verbose) cat("variable=",v," ")
        X       = dat[,-v]
        y       = dat[,v]
        meanx   = apply(X, 2, mean)
        normx   = sqrt(rowSums((t(X)-meanx)^2)/n)
        meany   = mean(y)
        normy   = sqrt(sum((y-meany)^2)/n)
        X       = scale(X, meanx, normx)
        y       = (y - mean(y)) / normy
        
        corr = abs(crossprod(X,y))
        # --------------------------------------------------------------
        # Determine the range of tuning parameters
        # --------------------------------------------------------------
            lamMax  = max(corr/n)
            thresh  = 2*exp(seq(log(lamMax), log(1/n), len=nlambda))
            lambda  = thresh/10
            tau     = 10^(seq(-6, -1, length.out=ntau))
            
            lambda  = rep(lambda, each=ntau)
            tau     = rep(tau, times=nlambda)
            
            w2kp    = which(lambda > 1/n)
            lambda  = n*lambda[w2kp]
            tau     = tau[w2kp]

        # --------------------------------------------------------------
        # estimate skeleton by penalized regression
        # --------------------------------------------------------------
        if (order) {
            o = order(corr,decreasing=T)
            o.back = order(o)
            wp      = PEN(X[,o], y, family="gaussian", penalty="LOG", 
            lambda=lambda, tau = tau)
            wpBetas = wp$beta[-1]
            coefNI[-v,i] = wpBetas[o.back]
            if (verbose) cat(date(), "\n")
        }else {
          wp      = PEN(X, y, family="gaussian", penalty="LOG", 
          lambda=lambda, tau = tau)
          coefNI[-v,i] = wp$beta[-1]
          if (verbose) cat( date(), "\n")
        }
    }
    return(coefNI)
}
