\name{mGAP}
\alias{mGAP}
\title{ adaptively penalized Sufficient Dimension Reduction }
\description{
  Dimension reduction regression and variable selection by Iterative Group-wise Adaptive Lasso
}
\usage{
mGAP(y, X, method=c("SIR", "cov", "spline", "power"),
 dimY=3, bs.ord=3, bs.inknots=max(1, dimY - bs.ord+1), 
 lambda=seq(1, 15, by=1), 
 tau=c(seq(.01,.08,by=.01), 0.1, 0.2), 
 pMax=20, L=10, epsilon=1e-4, n.max=500, b.update.order=1,
 p=NULL, offsetrow=0, offsetcol=0, transposeX=TRUE)
}
\arguments{
  \item{y}{ A numerical vector of the quantitative trait data }

  \item{X}{ A numerical marix or a character. 
  If it is a numerical matirx, it consists of the marker genotype data, each row corresponds to one sample/individual and each column corresponds to one covariate/marker. If it is a character vector, it is the name of the genotype data file, which must be a text file with different fileds separated by "whitespace". The data read from the text file may need to be transposed, see the parameter 'transposeX' for details.}

  \item{method}{ The method to transform the response variable. Currently four transformation methods are implemented: SIR (sliced inverse regression), cov (instraslice covariance), spline (b-spline transformations of order 'bs.ord' and 'bs.inknots' knots), and power (power transformation of y). }
  
  \item{dimY}{ dimension of the transformed Y. For method "SIR", it is the number of slices minus 1; for method "cov", it is the number of slices; for method "spline" with k inner knots and order m, it is k+m-1, for method "power", it is the number of power transformations. }
  
  \item{bs.ord}{ a positive integer giving the order of the spline function. This is the number of coefficients in each piecewise polynomial segment, thus a cubic spline has order 4. The default value of bs.ord is 3. }
  
  \item{bs.inknots}{ number of inner konts in b-spline }
  
  \item{lambda}{ See explanation of \code{tau} }

  \item{tau}{ lambda and tau are two vectors of possible values for hyper-parameter \eqn{\lambda} and \eqn{\tau}, respectively. One pair of \eqn{\lambda} and \eqn{\tau} will be selected from these possible values based on \code{criterion}}

  \item{pMax}{ maximum number of covariates to be included }

  \item{L}{ See the explanation of \code{epsilon} }

  \item{epsilon}{ If the maximum change of the regression coefficients is smaller than \code{epsilon} for \code{L} consecutive iterations, we say the IAL is converged. }
    
  \item{n.max}{ max number of iterations. }
  
  \item{b.update.order}{ The order to update each elements of b.
   Currently b.update.order can be 1 or 2.
   1 means b are updated according to the order of the corresponding covaraites in matrix X. 2 means b are updated by a random order.}
  
  \item{p}{ if X is character of file name, i.e., genotype data need to be read from a file, p indicates the number of genetic markers }

  \item{offsetrow}{ skip the first 'offsetrow' rows in the genotype data file }

  \item{offsetcol}{ skip the first 'offsetcol' columns in the genotype data file }
  
  \item{transposeX}{ If the genotype data is read from file, whether it need to 	be transposed. By default, we assume the data file include n rows (samples/individuals) and p columns (markers/covariates), and transpose is needed. }
}

\value{
 A list with 11 components:
  \item{score}{ BIC or cv scores at each combination of lambda and tau.}
  \item{w}{ which marker/covariate to keep.}
  \item{b}{ regression coefficients.}
  \item{lambda}{ hyperparameter lambda corresponding to the best score.}
  \item{tau}{ hyperparameter tau corresponding to the best score.}
  \item{method}{ The method to transform the response variable }
  \item{dimY}{ the number of transfomred response varaibles }
  \item{bs.ord}{ b-spline order for spline method, default bs.ord=3 correponds to quadratic spline }
  \item{bs.inknots}{ number of inner konts in b-spline }
  \item{yt}{ the trasformd response variables }
  \item{score2use}{ the best score among all combinitions of lambda and tau.}
}

\author{ Wei Sun <wsun@bios.unc.edu> }
\keyword{ methods }
