`apSDR` <-
function(y, X, method=c("SIR", "cov", "spline", "power"),
 dimY=3, bs.ord=3, bs.inknots=max(1, dimY - bs.ord+1), 
 lambda=seq(1, 15, by=1), 
 tau=c(seq(.01,.08,by=.01), 0.1, 0.2), 
 pMax=20, L=10, epsilon=1e-4, n.max=500, b.update.order=1,
 p=NULL, offsetrow=0, offsetcol=0, transposeX=TRUE)
{

# X=Xu; method="SIR";
# dimY=3; bs.ord=3; bs.inknots=max(1, dimY - bs.ord+1); 
# lambda=seq(1, 15, by=1);
# tau=c(.005, seq(.01,.05,by=.01), seq(.075, .2, by=.025));
# pMax=20; L=10; epsilon=1e-4; n.max=1000; b.update.order=1;
# p=NULL; offsetrow=0; offsetcol=0; transposeX=FALSE
  
  if(!is.vector(y)){
    stop("y is not a vector\n")
  }

  n = length(y)
  if(is.matrix(X)){
    if(nrow(X) !=n ){
      stop("dimensions of y and X do not match!\n")
    }
    p = ncol(X)
  }else if(is.character(X)){
    if(file.access(X, mode = 0)!=0){
      stop(X, "is not a valid file name.\n")
    }
    if(is.null(p)){
      stop("when X is a file name, p must be specified\n")
    }
  }else{
    stop("X must be either a data matrix or a valid input file name.\n")
  }
  
  # First set the mean value of y as 0
  y = y - mean(y)
    
  if(dimY==1){
    yt = matrix(y, ncol=1)
  }else if(method=="SIR"){
    # ------------------------------------- #
    # method: SIR
    # ------------------------------------- #
    sy = dr.slices(y, dimY+1)
    yt = NULL

    for(s in 1:(dimY+1)) {
      Js = rep(0, n)
      ws = which(sy$slice.indicator == s)
      Js[ws] = n/length(ws)
      yt = cbind(yt, Js)
    }
    
    w2drop = ceiling((dimY + 1)/2)
    yt = yt[,-w2drop]
  }else if(method=="cov"){
    # ------------------------------------- #
    # method: cov
    # ------------------------------------- #
    sy = dr.slices(y, dimY)
    yt = NULL

    for(s in 1:dimY) {
      Js = rep(0, n)
      Js[sy$slice.indicator == s] = 1
      y1 = Js*y
      y1 = y1 - mean(y1)
      yt = cbind(yt, y1)
    }
  }else if(method=="spline"){
    # ------------------------------------- #
    # method: spline
    # length(knots) - ord columns
    # that is bs.inknots + bs.ord columns
    # ------------------------------------- #
    knots = quantile(y, probs=seq(0, 1, length=(bs.inknots+2)))
    knots = c(rep(knots[1],bs.ord-1), knots, rep(knots[bs.inknots+2], bs.ord-1))
    yt    = splineDesign(knots, y, ord=bs.ord)
    yt    = yt[,-ncol(yt)]
  }else if(method=="power"){
    # ------------------------------------- #
    # method: power
    # ------------------------------------- #
    yt = NULL
    for(s in 1:dimY) {
      yt = cbind(yt, y^s)
    }
    sdyt = apply(yt, 2, sd)
    for(s in 1:dimY){
      yt[,s] = yt[,s]/sdyt[s]
    }
  }else{
    stop("invalid method\n")
  }

  h  = ncol(yt)
  yt = yt - matrix(apply(yt, 2, mean), nrow=n, ncol=h, byrow=TRUE)
  
  sdyt = apply(yt, 2, sd)
  for(s in 1:h){
    yt[,s] = yt[,s]/sdyt[s]
  }
  
  # ------------------------------------------------------- 
  # preparation for C code
  # -------------------------------------------------------
  n.iter = 0

  score = matrix(0, nrow=length(lambda), ncol=length(tau))
  scoNA = matrix(1, nrow=length(lambda), ncol=length(tau))
  
  dims = c(n, p, h, L, n.max, offsetrow, offsetcol, transposeX)
  dims = c(dims, length(lambda), length(tau), pMax)
  
  score2use = lambda2use = tau2use = -9999.9999
  
  B = matrix(0, nrow=p, ncol=h)
  
  # ------------------------------------------------------- 
  # Call the C function
  # -------------------------------------------------------

  if(is.character(X)){
    Z = .C("apSDRc", yt=as.double(yt), as.character(X), B = as.double(t(B)), 
      as.double(lambda), as.double(tau), as.integer(dims),
      as.double(epsilon), n.iter=as.integer(n.iter),
      as.integer(b.update.order), score=as.double(t(score)),
      scoNA=as.integer(t(scoNA)), score2use=as.double(score2use), 
      lambda2use=as.double(lambda2use), tau2use=as.double(tau2use), 
      PACKAGE="BPrimm")
  }else{
    Z = .C("apSDRr", yt=as.double(yt), as.double(X), B = as.double(t(B)), 
      as.double(lambda), as.double(tau), as.integer(dims),
      as.double(epsilon), n.iter=as.integer(n.iter),
      as.integer(b.update.order), score=as.double(t(score)),
      scoNA=as.integer(t(scoNA)), score2use=as.double(score2use), 
      lambda2use=as.double(lambda2use), tau2use=as.double(tau2use), 
      PACKAGE="BPrimm")
  }
    
  score = matrix(Z$score, nrow=length(lambda), ncol=length(tau), byrow=TRUE)
  scoNA = matrix(Z$scoNA, nrow=length(lambda), ncol=length(tau), byrow=TRUE)
  score[scoNA==1] = NA
  
  if(all(is.na(as.vector(score)))){
    warning("no acceptable lambda/tau are found\n")
    return(NULL)
  }
    
  bS = matrix(Z$B, nrow=p, ncol=h, byrow=TRUE)
  bNom = apply(bS, 1, function(v){sqrt(sum(v*v))})
  w2kp = which(bNom > 1e-10)
  b2kp = bS[w2kp,]
  lambda1 = Z$lambda2use
  tau1    = Z$tau2use

  rownames(score) = lambda
  colnames(score) = tau
  
  if(length(w2kp) > 1){ rownames(b2kp) = w2kp }
  
  ll = list(score=score, w=w2kp, b=b2kp, lambda=lambda1, tau=tau1, 
    method = method, dimY=h, bs.ord=bs.ord, bs.inknots=bs.inknots, 
    yt = yt)
  
  ll[["score2use"]] = Z$score2use
  class(ll) = "apSDR"
  ll
}

