/*
 * =======================================================================
 *			Verify ZEROIN routine
 */
#include "stdio.h"
#include "math.h"

double zeroin(double ax, double bx, double (*f)(), double tol, int H, 
 double kappa_j, double *sigma2, double Xj2_j, double *bj_bar);


double fb(double b_norm_j, int H, double kappa_j, double *sigma2, 
 double Xj2_j, double *bj_bar)
{
  double val = 1/(kappa_j*kappa_j);
  double tmp = kappa_j*b_norm_j;
  
  int h;
  double tmp1;
  
  for(h=0; h<H; h++){
    tmp1 = 1/(tmp + sigma2[h]/Xj2_j);
    val -= tmp1*tmp1*bj_bar[h]*bj_bar[h];
  }
  
  return(val);
}

main()
{
  double val, bj_norm_lower=0.0, bj_norm_upper=1.0, kappa_j=1.0;
  int H=3;
  double sigma2[3], Xj2_j=1.0, bj_bar[3], tval;
  
  sigma2[0] = 1.2;
  sigma2[1] = 1.0;
  sigma2[2] = 1.5;
  bj_bar[0] = 1.1;
  bj_bar[1] = 0.9;
  bj_bar[2] = 1.0;

  val = zeroin(bj_norm_lower, bj_norm_upper, fb, 0.0, 
              H, kappa_j, sigma2, Xj2_j, bj_bar);
  tval = fb(val, H, kappa_j, sigma2, Xj2_j, bj_bar);
  
  printf("estimated root is %f, and f(%f)=%e\n", val, val, tval);
}
