\name{IMAL}
\alias{IMAL}
\title{ Iterative Multivariate Adaptive Lasso }
\description{
  Dimension reduction regression and variable selection by Iterative Multivariate Adaptive Lasso
}
\usage{
IMAL(y, X, method=c("SIR", "cov", "spline", "power"),
 dimY=5, bs.ord=4, bs.inknots=max(1, dimY - bs.ord + 1), 
 delta=seq(0, 7.5, by=0.5), tau = c(0.01, 0.02, 0.05, 0.1, 0.15, 0.2), 
 pMax=20, L=10, epsilon=1e-4, n.max=1000,  b.update.order=1, 
 p=NULL, offsetrow=0, offsetcol=0, transposeX=FALSE)
}
\arguments{
  \item{y}{ A numerical vector of the quantitative trait data }

  \item{X}{ A numerical marix or a character. 
  If it is a numerical matirx, it consists of the marker genotype data,
  each row corresponds to one sample/individual and
  each column corresponds to one covariate/marker. 
  If it is a character vector, it is the name of the genotype data file. }

  \item{method}{ The method to transform the response variable }
  
  \item{dimY}{ dimension of the transformed Y. For method "SIR", it is the number of slices minus 1; for method "cov", it is the number of slices; }
  
  \item{bs.ord}{ a positive integer giving the order of the spline function. This is the number of coefficients in each piecewise polynomial segment, thus a cubic spline has order 4. Defaults to 4. }
  
  \item{bs.inknots}{ number of inner konts in b-spline }
  
  \item{delta}{ See explanation of \code{tau} }

  \item{tau}{ delta and tau are two vectors of possible values for hyper-parameter $\delta$ and $\tau$, respectively. One pair of $\delta$ and $\tau$ will be selected from these possible values based on \code{criterion}}

  \item{pMax}{ maximum number of covariates to be included }

  \item{L}{ See the explanation of \code{epsilon} }

  \item{epsilon}{ If the maximum change of the regression coefficients is smaller than \code{epsilon} for \code{L} consecutive iterations, we say the IAL is converged}
    
  \item{n.max}{ max number of iterations. }
  
  \item{b.update.order}{ The order to update each elements of b.
   Currently b.update.order can be 1 or 2.
   1 means b are updated according to the order of the corresponding covaraites in matrix X. 
   2 means b are updated by a random order.}
  
  \item{p}{ if X is character, i.e., genotype data need to be read from a file, p indicate the number of genetic markers }

  \item{offsetrow}{ skip the first 'offsetrow' rows in the genotype data file }

  \item{offsetcol}{ skip the first 'offsetcol' columns in the genotype data file }
  
  \item{transposeX}{ If the genotype data is read from file, whether it need to be transposed. }
}

\value{
 A list with 10 components:
  \item{score}{ BIC or cv scores at each combination of delta and tau.}
  \item{w}{ which marker/covariate to keep.}
  \item{b}{ regression coefficients.}
  \item{delta}{ hyperparameter delta corresponding to the best score.}
  \item{tau}{ hyperparameter tau corresponding to the best score.}
  \item{method}{ The method to transform the response variable }
  \item{dimY}{ the number of transfomred response varaibles }
  \item{bs.ord}{ b-spline order for spline method, default bs.ord=3 correponds to quadratic spline }
  \item{bs.inknots}{ number of inner konts in b-spline }
  \item{yt}{ the trasformd response variables }
  \item{score2use}{ the best score among all combinitions of delta and tau.}
}

\author{ Wei Sun <wsun@bios.unc.edu> }
\keyword{ methods }
