`Lasso` <-
function(y, X, lambda=NULL, pMax=20, alpha=0.95){
  
  n = length(y)
  if(nrow(X) !=n){
    stop("dimensions of y and X do not match!\n")
  }
  p = ncol(X)  
  
  one   = rep(1, n)
  meanx = drop(one %*% X)/n
  X     = scale(X, meanx, FALSE)
  mu    = mean(y)
  y     = drop(y - mu)

  
  # ------------------------------------------------------- 
  # If there is only one lambda and one gamma, 
  # the parameter selection is not needed
  # -------------------------------------------------------

  if(length(lambda) == 1 && length(gamma) == 1){
    lambda1 = lambda[1]
    gamma1  = gamma[1]
    wMin    = 1
  }else{
    # ------------------------------------------------------- 
    # Use BIC to select variables
    # -------------------------------------------------------
    
    if(is.null(lambda)){
      gn = glmnet(X, y, family="gaussian", alpha=alpha)
    }else{
      gn = glmnet(X, y, family="gaussian", alpha=alpha, lambda=lambda)
    }
    
    wk1 = which(gn$df > 0 & gn$df <= pMax)
    BIC = rep(NA, length(gn$lambda))

    for(k1 in wk1){
      lambda1 = gn$lambda[k1]
      bhat    = gn$beta[,k1]
    
      w2kp = which(abs(bhat) > 1e-10)
      b2kp = bhat[w2kp]
      
      if(length(w2kp)==1){
        resd = y - X[,w2kp] * b2kp
      }else{
        resd = y - X[,w2kp] %*% b2kp
      }
      BIC[k1] = log(sum(resd*resd)/n) + length(w2kp)*log(n)/(n)        
    }
    
    if(all(is.na(as.vector(BIC)))){
      warning("no acceptable lambda is found\n")
      return(NULL)
    }
    
    wMin    = which.min(BIC)
    lambda1 = gn$lambda[wMin]    
  }
  
  bhat = gn$beta[,wMin]

  w2kp = which(abs(bhat) > 1e-10)
  b2kp = bhat[w2kp]

  ll = list(BIC=BIC, w=w2kp, b=b2kp, lambda=lambda1)
  
  class(ll) = "Lasso"
  return(ll)  
}

