function [maxpar,maxsiga2, maxThz, Cov, loglik]=main(subject, obsy, obsx, obsax, obst,...
    obsr, obsz, obsaz, position, nsub)
%obsx must have the first column to be intercept ones.
n=size(obst,1);m=size(obsx,1);dx=size(obsx,2);dax=size(obsax,2);
dz=size(obsz,2);daz=size(obsaz,2); % often, daz=dax
epsilon=0.001;  maxit=2000;

weight0=[2.22939364554E-013, 4.39934099226E-010, 1.08606937077E-007, 7.8025564785E-006,...
    0.000228338636017,  0.00324377334224, 0.0248105208875,0.10901720602,0.286675505363,0.462243669601];
weight0=[weight0,weight0]';
numval0=[-5.38748089001, -4.60368244955,-3.94476404012,-3.34785456738, -2.78880605843, -2.25497400209, ...
             -1.73853771212,-1.2340762154,-0.737473728545,-0.245340708301];
numval0=[numval0,-numval0]';

npt=length(numval0);

numval=numval0;   weight=weight0;
if (dax>1)
     for k=1:1:(dax-1)
        newleng=length(numval);
        numval=[kron(numval, zeros(npt,1)+1), kron(zeros(newleng,1)+1, numval0)];
        weight=kron(weight, zeros(npt,1)+1).*kron(zeros(newleng,1)+1, weight0);
    end
end

% EM algorithms to compute MLE
betax=inv(obsx'*obsx)*(obsx'*obsy);
sigy2=sum((obsy-obsx*betax)'*(obsy-obsx*betax))/m;
gamma=coxphm(obst,obsr,obsz,zeros(dz,1),epsilon, maxit);

oldpar=[betax;zeros(daz,1);gamma; sigy2];
oldsiga2=sigy2*diag(zeros(dax,1)+1);
oldThz=zeros(n,1);
for i=1:1:n
    denom=sum(exp(obsz*gamma).*(obst>=obst(i)));
    oldThz(i)=obsr(i)/denom;
end

error=2*epsilon;  iter=0;
while (error>epsilon) & (iter<maxit)
     [EXa1,EXa2,Eea,EZa1ea,EZa2ea, EZa, Eaa]=Eest(oldpar, oldsiga2, oldThz, subject, obsy, obsx, obsax, ...
                                                   obst, obsr, obsz, obsaz, position, nsub, weight, numval);
    [newpar, newsiga2, newThz]=Mest(oldpar, oldsiga2, oldThz, EXa1,EXa2,...
                                    Eaa, Eea, EZa1ea, EZa2ea, EZa,subject, obsy, obsx, obsax, obst,...
                                    obsr, obsz, obsaz, position, nsub, weight, numval);
    error=sum(abs(newpar-oldpar))+sum(abs(newsiga2-oldsiga2)*(repmat(1,dax,1)))+sum(abs(newThz-oldThz));
    iter=iter+1;    oldpar=newpar;  oldsiga2=newsiga2;  oldThz=newThz;
    [iter,error]
   % newpar'
   % newsiga2
end
maxpar=newpar; maxsiga2=newsiga2; maxThz=newThz;
h=1/sqrt(n);
[loglik, Cov]=profCov2(maxpar, maxsiga2, maxThz, subject, obsy, obsx, obsax, ...
                       obst, obsr, obsz, obsaz, position, nsub, weight, numval,epsilon,maxit,h);
