function likvec=likVec(temppar, tempsiga2, Thz, subject, obsy, obsx, obsax, ...
                       obst, obsr, obsz, obsaz, position, nsub, weight, numval)

n=size(obst,1); m=size(obsx,1); dx=size(obsx,2); dax=size(obsax,2);
dz=size(obsz,2); daz=size(obsaz,2); %  often, daz=dax

betax=temppar(1:dx);  phi=temppar(dx+(1:daz));  gamma=temppar((dx+daz+1):(dx+daz+dz));
sigy2=temppar(end);   

likvec=zeros(n,1);
tempThz=Thz;  tempThz(obsr==0)=1;

pi=3.1415926535898;
for i=1:1:n
    index=position(i):1:(position(i)+nsub(i)-1);
    vara=inv(obsax(index,:)'*obsax(index, :)/(sigy2)+inv(tempsiga2));
    ma=vara*(obsax(index,:)'*(obsy(index,1)-obsx(index,:)*betax)/sigy2+obsr(i,1)*phi.*obsaz(i,:)');
    NUM=repmat(ma, 1, size(numval,1))+sqrt(2)*sqrtm(vara)*numval';
    Za=NUM'.*repmat(obsaz(i,:),size(numval,1),1);
    cumi=sum(Thz.*(obst<=obst(i)));
    likvec(i)=-nsub(i)*log(sqrt(2*pi*sigy2))-log(power(sqrt(2*pi),dax)*sqrt(det(tempsiga2)))+...
               obsr(i)*log(tempThz(i))+obsr(i)*obsz(i,:)*gamma;
    likvec(i)=likvec(i)-((obsy(index)-obsx(index,:)*betax)'*(obsy(index)-obsx(index,:)*betax))/(2*sigy2);
    likvec(i)=likvec(i)+ma'*inv(vara)*ma/2+log(power(sqrt(2*pi),dax)*sqrt(det(vara)))...
              +log(sum(weight.*exp(-exp(Za*phi+obsz(i,:)*gamma)*cumi)));
end




