function newcoef=coxphm(Y,R,X,coef0,epsilon, maxiter)

% cox regression using data Y,R, part of L
% num is the number of covariates in the
% regression, coeff0 is the intial value Newton-Raphson iteration
n=length(Y); numx=size(X,2);
oldcoef=coef0; error=1; iter=0;
% Newton-Raphson iteration
while (error > epsilon & iter < maxiter)
    score=zeros(numx,1); dscore=zeros(numx, numx);
    for i=1:1:n
        if (R(i)==1)
            tempindex=(Y>=Y(i)).*exp(X*oldcoef);
            nom=X'*tempindex;
            denom=sum(tempindex);
            score=score+X(i,:)'-nom/denom;
            dscore=dscore-(X'*(repmat(tempindex,1,numx).*X)/denom-nom*nom'/denom^2);
        end
    end
    newcoef=oldcoef-inv(dscore)*score;
    error=sum(abs(newcoef-oldcoef)); iter=iter+1;
    [iter, error]
    oldcoef=newcoef;
end
