function [newpar, newsiga2, newThz]=Mest(oldpar, oldsiga2, oldThz, EXa1,EXa2, ...
                                         Eaa, Eea, EZa1ea, EZa2ea, EZa, subject, obsy, obsx, obsax, obst,...
                                         obsr, obsz, obsaz, position, nsub, weight, numval)
% This function is to M-step in EM algorithm 
% obsy: longitudinal response
% obsx: longitudinal fixed effect (including intercept)
% obst: visit times
% position: starting positions for subjects in data
% wight/numval: for Gauss-Quadrature approximation
% n: number of subjects

%EXa1: obsax*a  (m,1) %EXa2: (obsax*a)^2 (m,1)
%Eea:  exp(obsz*a)  (n,1) %EZa1ea: obsaz*a*exp(obsaz*a)  (n,1)
%EZa2ea: (obsaz*a)^2*exp(obsaz*a) (n,1)%EZa:  obsax*a
%Eaa:   a*a  (dax,dax,n)

n=size(obst,1); m=size(obsx,1); dx=size(obsx,2); dax=size(obsax,2);
dz=size(obsz,2); daz=size(obsaz,2); %  often, daz=dax

betax=oldpar(1:dx,1);  phi=oldpar(dx+(1:daz));  gamma=oldpar((dx+daz+1):(dx+daz+dz));
sigy2=oldpar(end);   siga2=oldsiga2;

tempy=obsy-EXa1; newbetax=inv(obsx'*obsx)*(obsx'*(tempy));
newsigy2=((tempy-obsx*newbetax)'*(tempy-obsx*newbetax)+sum(EXa2)-sum(power(EXa1,2)))/m;
newsiga2=Eaa/n;

deriv1=zeros(daz+dz,1);  deriv2=zeros(daz+dz,daz+dz);
for i=1:1:n
    if (obsr(i)==1)
    tempind=(obst>=obst(i)).*exp(obsz*gamma);
    denom=sum(Eea.*tempind);
    nom=[EZa1ea'*tempind; obsz'*(Eea.*tempind)];
    deriv1=deriv1+obsr(i,1)*([EZa(i,:)'; obsz(i,:)']-nom/denom);
    
    tempvec=obsz.*repmat(sqrt(Eea.*tempind),1,dz);
    tempmatrix=zeros(daz+dz, daz+dz);
    for k=1:1:daz
        for l=1:1:daz
            tempmatrix(k,l)=EZa2ea(:, (k-1)*daz+l)'*tempind;
        end
        tempmatrix(k, daz+(1:dz))=EZa1ea(:,k)'*(repmat(tempind, 1, dz).*obsz);
        tempmatrix(daz+(1:dz), k)=tempmatrix(k, daz+(1:dz))';
    end
    tempmatrix(daz+(1:dz), daz+(1:dz))=tempvec'*tempvec;
    deriv2=deriv2-obsr(i)*(tempmatrix*denom-nom*nom')/(denom*denom);
    end
end
coxcoef=[phi;gamma]-inv(deriv2)*deriv1;
newphi=coxcoef(1:daz); newgamma=coxcoef((1+daz):end);
newpar=[newbetax;newphi;newgamma;newsigy2];

newEea=zeros(n,1);
for i=1:1:n
    indi=position(i):(position(i)+nsub(i)-1);
    vara=inv(obsax(indi,:)'*obsax(indi, :)/(sigy2)+inv(siga2));
    ma=vara*(obsax(indi,:)'*(obsy(indi,1)-obsx(indi,1:dx)*betax)/sigy2+obsr(i)*phi.*obsaz(i,:)');
    NUM=repmat(ma, 1, size(numval,1))+sqrt(2)*sqrtm(vara)*numval';
    Za=NUM'.*repmat(obsaz(i,:),size(numval,1),1);
    tempvec=weight.*exp(-exp(Za*phi+obsz(i,:)*gamma)*sum(oldThz(obst<=obst(i),1)));
    tempweight=tempvec/sum(tempvec);
    newEea(i)=tempweight'*exp(Za*newphi);
end

newThz=zeros(n,1);
for i=1:1:n
    newThz(i,1)=obsr(i)/sum(newEea.*(obst>=obst(i)).*exp(obsz*newgamma));
end



