function [EXa1,EXa2,Eea,EZa1ea,EZa2ea, EZa, Eaa]=Eest(oldpar, oldsiga2, oldThz, ...
                                                      subject, obsy, obsx, obsax, ...
                                                      obst, obsr, obsz, obsaz, position, nsub, weight, numval)
% obsy, obsx obsax are for longitudinal; obsx include intercept
% obst, obsr, obsz, obsaz are for survival 
% oldpar: betax, phi, gamma   oldsiga: sigama-a
% position: starting position for i-th subject
% nsub: number of longitudinal observations
% weight, numval: dax dimensional gauss-quadrature matrices dax X 10^dax, 1 X 10^dax

   n=size(obst,1); m=size(obsx,1); dx=size(obsx,2); dax=size(obsax,2);
   dz=size(obsz,2); daz=size(obsaz,2); %  often, daz=dax
   
   betax=oldpar(1:dx);  phi=oldpar(dx+(1:daz));  gamma=oldpar((dx+daz+1):(dx+daz+dz));
   sigy2=oldpar(end);   siga2=oldsiga2;

   EXa1=zeros(m,1);  EXa2=zeros(m,1);   Eea=zeros(n,1); EZa1ea=zeros(n,daz);  EZa2ea=zeros(n,daz^2);
   Eaa=zeros(dax,dax);  EZa=zeros(n,daz);
   for i=1:1:n
       indi=position(i):(position(i)+nsub(i)-1);
       vara=inv(obsax(indi,1:dax)'*obsax(indi, 1:dax)/(sigy2)+inv(siga2));
       ma=vara*(obsax(indi,:)'*(obsy(indi,1)-obsx(indi,:)*betax)/sigy2+obsr(i)*phi.*obsaz(i,:)');
       NUM=repmat(ma, 1, size(numval,1))+sqrt(2)*sqrtm(vara)*numval';
       Za=NUM'.*repmat(obsaz(i,:),size(numval,1),1);
       tempvec=weight.*exp(-exp(Za*phi+obsz(i,:)*gamma)*sum(oldThz(obst<=obst(i),1)));
       tempweight=tempvec/sum(tempvec);
       Eea(i,1)=tempweight'*exp(Za*phi);
       EZa(i,:)=tempweight'*Za;
       EZa1ea(i,:)=tempweight'*(repmat(exp(Za*phi), 1, daz).*Za);
       for k=1:1:daz
           for l=1:1:daz
       EZa2ea(i,(k-1)*daz+l)=tempweight'*(exp(Za*phi).*Za(:,k).*Za(:,l));
           end
       end
       for j=1:1:nsub(i)
          row=position(i)+j-1; 
          EXa1(row,1)=tempweight'*(NUM'*obsax(row,:)');
          EXa2(row,1)=tempweight'*power(NUM'*obsax(row,:)',2);
       end
      Eaa=Eaa+NUM*(repmat(tempweight,1,dax).*NUM');
  end
