% main program Y---lambdaY0 log(Y)
% Gaussian_quadrature
load startnum;
load nsim;
n=100;

npt=20; [numb,wb]=gauher(npt);
wb=kron(wb,wb); numb=sqrt(2)*[kron(numb, repmat(1,npt,1)), kron(repmat(1,npt,1),numb)];


% Start Simulations
rho=1; r=0;
betaY0=[1;0.5]; betaT0=-0.5; phi0=[1; 0.5]; sigb20=[1, -0.4; -0.4, 1];
lambdaY0=1; lambdaT0=0.5; tauT=2; sigy2=1;

dY=length(betaY0); dT=length(betaT0)+length(phi0);
%n=100; nsim=1000;

nptY=3; testptY=(1:1:nptY)'; nptT=3; testptT=tauT*(1:1:nptT)'/(1+nptT);
truepar=[betaY0; (testptY);...
       betaT0; phi0; lambdaT0*testptT.^2/2; sigb20(1,1); sigb20(1,2); sigb20(2,2)];
parest=zeros(nsim, dY+nptY+dT+nptT+3); sdest=zeros(nsim, dY+nptY+dT+nptT+3);

numY=0; cenrateT=0;
for simind=1:1:nsim
    rand('seed',1123+simind+startnum);    randn('seed',1123+simind+startnum);
    [ID, Y, X,T,Delta,Z]=simulation(betaY0, lambdaY0, betaT0, phi0,...
                         lambdaT0, sigb20, n, rho,r, tauT, sigy2);
    NN=length(Y); nn=sum(Delta);
    indY=(repmat(Y,1,NN)>=repmat(Y',NN,1));
    indT=(repmat(T,1,n)>=repmat(T',n,1));

    indID=zeros(n,NN);
    for i=1:1:n
        indID(i,ID==i)=1;
    end

    oldbetaY=betaY0;  oldbetaT=betaT0; oldphi=phi0; oldsigb2=sigb20;
    oldlambdaY=1./(indY*repmat(1,NN,1)); oldlambdaT=Delta./(indT*repmat(1,n,1));

    initial=[oldbetaY; oldlambdaY; oldbetaT; oldphi; oldlambdaT(Delta==1);oldsigb2(1,1);...
             oldsigb2(1,2); oldsigb2(2,2)];

    options=optimset('GradObj', 'on', 'Hessian', 'on', 'Display', 'off');
    [newpar, fval, exitflag, output1, grad, hessian]=fminunc(@fgh, initial, options, ...
        ID, Y, X, T, Delta, Z, indY, indT, indID, n, rho, r, numb,wb, sigy2);
    newbetaY=newpar(1:dY); newlambdaY=newpar(dY+(1:NN));
    newtempT=newpar(dY+NN+(1:dT)); newbetaT=newtempT(1:(dT-2)); newphi=newtempT((dT-1):dT);
    newlambdaT=zeros(n,1); newlambdaT(Delta==1)=newpar(dY+NN+dT+(1:nn));
    newsigb2=[newpar(dY+NN+dT+nn+1), newpar(dY+NN+dT+nn+2); ...
                 newpar(dY+NN+dT+nn+2), newpar(dY+NN+dT+nn+3)];
    cov=inv(hessian)/n;
    predmatrix=[diag(1+zeros(dY,1)), zeros(dY, NN+dT+nn+3);
        zeros(nptY, dY), repmat(testptY, 1,NN)>=repmat(Y', nptY, 1), zeros(nptY, dT+nn+3);
        zeros(dT, dY+NN), diag(1+zeros(dT,1)), zeros(dT, nn+3);
        zeros(nptT, dY+NN+dT), repmat(testptT, 1, nn)>=repmat(T(Delta==1)', nptT, 1), ...
        zeros(nptT,3); zeros(3, dY+NN+dT+nn), diag(1+zeros(3,1))];

    tempest=predmatrix*[newbetaY; newlambdaY; newbetaT; newphi; ...
                                   newlambdaT(Delta==1); newsigb2(1,1); newsigb2(1,2); newsigb2(2,2)];
    tempsd=sqrt(diag(predmatrix*cov*predmatrix'));
    parest(simind,:)=tempest';  sdest(simind,:)=tempsd';
    numY=(numY*(simind-1)+mean(sum(indID')))/simind;
    cenrateT=(cenrateT*(simind-1)+nn/n)/simind;
    if (simind>2)
         Sind=(1:1:simind)';
        [simind, numY, cenrateT]
        indLambda=[(dY+(1:nptY)'); (dY+nptY+dT+(1:nptT)'); dY+nptY+dT+nptT+1; dY+nptY+dT+nptT+3];
        output=[truepar'; mean(parest(Sind,:))-truepar'; 
            sqrt(var(parest(Sind,:)));
            mean(sdest(Sind,:));
            mean(abs(parest(Sind,:)-repmat(truepar', simind,1))<1.96*sdest(Sind,:))];
        output(5, indLambda)=...
            mean(abs(log(parest(Sind, indLambda))-repmat(log(truepar(indLambda)'), simind,1))...
                 <1.96*sdest(Sind,indLambda)./parest(Sind, indLambda));
        % Satterthwaite approximation
        Z=parest(Sind,dY+nptY+dT+nptT+1)./sdest(Sind,dY+nptY+dT+nptT+1); nu=2*power(Z,2);
        output(5,dY+nptY+dT+nptT+1)=mean((nu.*parest(Sind,dY+nptY+dT+nptT+1)./chi2inv(0.975,nu)<= sigb20(1,1))...
                           .*(nu.*parest(Sind,dY+nptY+dT+nptT+1)./chi2inv(0.025,nu)>= sigb20(1,1)));
        Z=parest(Sind,dY+nptY+dT+nptT+3)./sdest(Sind,dY+nptY+dT+nptT+3); nu=2*power(Z,2);
        output(5,dY+nptY+dT+nptT+3)=mean((nu.*parest(Sind,dY+nptY+dT+nptT+3)./chi2inv(0.975,nu)<= sigb20(2,2))...
                           .*(nu.*parest(Sind,dY+nptY+dT+nptT+3)./chi2inv(0.025,nu)>= sigb20(2,2)));
        output
        save parest parest -ASCII;
        save sdest sdest -ASCII;
        save numY numY -ASCII;
        save cenrateT cenrateT -ASCII;
        save simind simind -ASCII;
        save output output -ASCII;
    end
end

