function [ID, Y, Delta, X, Z]=simulation(beta0,Sigma0, alpha0, tau, rho, r1, r2, tauC, n)

% simulate data
% G(t) is Box-Cox transformation or log-transformation
% Lambda(t)=alpha0*log(1+t);
mz=size(Sigma0,1);
mx=length(beta0);
C=min(rand(n,1)*(tauC-tau/2)+tau/2,tau);

TX1=(rand(n,1)<0.5);
TX2=randn(n,1); TX2(abs(TX2)>1)=1;
TX2=TX1+TX2;
TX=[TX1, TX2];
TZ=[1+zeros(n,1)];
raneff=randn(n,1)*sqrtm(Sigma0);
EbetaZ=exp(TX*beta0+(TZ.*raneff)*repmat(1,mz,1));

ID=0;  Y=0;   Delta=0;  X=zeros(1, mx);  Z=zeros(1, mz);
for i=1:1:n
    tempY=0;     lastY=0;
    while (lastY<C(i))
        if (rho>0)
            tempvalue=-log(rand(1))+((1+alpha0*log(1+lastY)*EbetaZ(i))^rho-1)/rho;
            newY=((tempvalue*rho+1)^(1/rho)-1)/EbetaZ(i)/alpha0;
            newY=exp(newY)-1;
        end 
        if(rho==0)
             tempvalue=-log(rand(1))+r1*log(1+r2*alpha0*log(1+lastY)*EbetaZ(i));
             newY=(exp(tempvalue/r1)-1)/r2/EbetaZ(i)/alpha0;
             newY=exp(newY)-1;
         end
        if (newY<C(i)) 
            tempY=[tempY;newY];
        end
        lastY=newY;
    end
    tempY=[tempY(2:end);C(i)];
    ni=length(tempY);
    ID=[ID; repmat(i,ni,1)];
    Y=[Y;tempY];
    Delta=[Delta; repmat(1,ni-1,1);0];
    X=[X; repmat(TX(i,:), ni,1)];
    Z=[Z; repmat(TZ(i,:), ni,1)];
end

Y=Y(2:end);
ID=ID(2:end);
Delta=Delta(2:end);
X=X(2:end,:);
Z=Z(2:end,:);




