function [f, f1]=recursive(ID, Y, XX, ZZ, Delta, n, NN, mb, alpha, beta, ...
                            Tbb, Eweight, rho, r1, r2)

EXZ=exp(repmat(XX*beta, 1, mb)+ZZ*Tbb);

nn=sum(Delta==1);
nbeta=length(beta);
f=zeros(nn,1);
f1=zeros(nn, nbeta+1);

[OY, index]=sort(Y(Delta==1));

f(nn)=alpha; f1(nn,1)=1; 
for k=2:1:nn
    j=nn-k+1;
    Fj=1-sum(f((j+1):end));
    Fj1=-repmat(1,1, nn-j)*f1((j+1):end, :);
    Cind=(OY(j)<=Y).*(OY(j+1)>Y);
    TDelta=Delta(Cind==1);
    nj=sum(Cind);
    Ewj=Eweight(Cind==1,:);
    EXZj=EXZ(Cind==1,:);
    [G0,G1,G2,G3]=Gfun(EXZj.*repmat(Fj,nj,mb), rho, r1, r2);
    EG0=(G0.*Ewj)*repmat(1,mb,1);
    EG1=(G1.*EXZj.*Ewj)*repmat(1,mb,1);
    EG2=(G2.*EXZj.^2.*Ewj)*repmat(1,mb,1);
    EG2G1=(G2./G1.*EXZj.*Ewj)*repmat(1,mb,1);
    EDG2G1=((G3./G1-G2.^2./G1.^2).*EXZj.^2.*Ewj)*repmat(1,mb,1);
    
    coef1=-EG2G1;
    coef1(TDelta==0)=EG1(TDelta==0);
    coef2=-EDG2G1;
    coef2(TDelta==0)=EG2(TDelta==0);
    
    tempf=1/f(j+1)+sum(coef1);
    tempfalpha=-f1(j+1,1)/f(j+1)^2+sum(coef2)*Fj1(1);
    tempfbeta=-f1(j+1,2:end)/f(j+1)^2 ...
        +coef2'*(XX(Cind==1,:)*Fj+repmat(Fj1(:,2:end), nj,1))...
        +coef1'*XX(Cind==1,:);
    f(j)=1/tempf;
    f1(j,:)=-f(j)^2*[tempfalpha, tempfbeta];
end




