% transformation
rho=1; r1=1; r2=1/r1;
n=200;

beta0=[-0.5;1];
Sigma0=1; gamma0=Sigma0;
alpha0=0.2;
%Lambda(t)=alpha0*log(1+t)
nbeta=length(beta0); ngamma=length(gamma0); mz=size(Sigma0,1);
tau=4; tauC=6;

testpt=tau./[4;3;2;1]; truept=alpha0*log(1+testpt);
npt=length(testpt);

% Gaussian_quadrature
w=[2.22939364554E-013, 4.39934099226E-010, 1.08606937077E-007, ...
        7.8025564785E-006, 0.000228338636017, 0.00324377334224,...
        0.0248105208875,0.10901720602,0.286675505363,0.462243669601];
ww=[w,w]';
b=[-5.38748089001, -4.60368244955,-3.94476404012,-3.34785456738, ...
        -2.78880605843, -2.25497400209, -1.73853771212, ...
        -1.2340762154,-0.737473728545,-0.245340708301];
bb=sqrt(2)*[b,-b]';

load startnum;
load simind;
load unit;
simnum=unit;
if (simind==0)
parest=zeros(nbeta+ngamma+npt,simnum);
sdest=parest;
countind=zeros(simnum,1);
mse=0; event=0;
end
if (simind>0)
load parest;
load sdest;
load countind;
load mse;
load event;
end

epsilon=0.005;  maxiter=100;

tempsim=simind;
for simind=(tempsim+1):1:simnum
    rand('seed',startnum+simind);
    randn('seed',startnum+simind);
    
    [ID, Y, Delta, X, Z]=simulation(beta0,Sigma0, alpha0, tau, ...
                                               rho, r1, r2, tauC, n);
    NN=length(Y);    XX=[repmat(1,NN,1),X]; ZZ=Z;
    nn=sum(Delta==1);
    OY=sort(Y(Delta==1));
    indY=(repmat(Y, 1, nn)>=repmat(OY',NN,1));
    indID=zeros(n, NN);
    for i=1:1:n
        indID(i,ID==i)=1;
    end
    event=((simind-1)*event+nn/n)/simind;

    oldbeta=[0;zeros(length(beta0),1)];
    oldalpha=1/nn;
    oldf=oldalpha+zeros(nn,1);
    oldSigma=diag(1+zeros(mz,1));
    
    error=1; iter=0;
    while (error>epsilon & iter<maxiter)
       [Tbb, weight]=Estep(ID, Y, XX, ZZ, Delta, n, oldbeta, oldf, oldSigma, ...
                                 bb, ww, indY, indID, rho, r1, r2);
        %weight is n X mb matrix
        [newbeta, newf, newSigma]=Mstep(ID, Y, XX, ZZ, Delta, n, ...
                           oldalpha, oldbeta, oldSigma, Tbb, weight, ...
                           indY, indID, rho, r1, r2);
        error=max([abs(newbeta-oldbeta); abs(newf-oldf); abs(diag(newSigma-oldSigma))]);
        iter=iter+1;
        oldbeta=newbeta; oldf=newf; oldSigma=newSigma; oldalpha=newf(nn);
%         [iter, error]
%         [[0;beta0;oldSigma], [newbeta;newSigma]]
    end
    estpar=[newbeta(2:end);newSigma;newf*exp(newbeta(1))];
    cov=covest(ID, Y, XX, ZZ, Delta, n, newf, newbeta, newSigma, ...
        bb, weight, indY, indID, rho, r1, r2);
    OY=sort(Y(Delta==1));
    MX=[diag(1+zeros(nbeta+ngamma,1)), zeros(nbeta+ngamma,nn);
        zeros(npt, nbeta+ngamma),      repmat(testpt,1,nn)>=repmat(OY',npt,1)];
    sd=diag(MX*cov*MX');
    
    if (min(sd)>0)
        countind(simind)=1;
        parest(:, simind)=MX*estpar;
        sdest(:,simind)=sqrt(sd);
        [OY, Oind]=sort(Y(Delta==1));
        nind=sum(countind);
        mse=((nind-1)*mse+mean((cumsum(newf)*exp(newbeta(1))-alpha0*log(1+OY)).^2))/nind;
    end
    
    nind=sum(countind);
    if (nind>1)
        [simind, nind]
        outind=(1:1:simind)';
        outind=outind(countind(1:simind)==1);
        
        expind=(nbeta+ngamma):(nbeta+ngamma+npt);
        par=parest(:,outind);
        sd=sdest(:,outind);
        Tpar=par; Tsd=sd;
        
        Tpar(expind,:)=log(par(expind,:));
        Tsd(expind,:)=sd(expind,:)./par(expind,:);
        
        true=[beta0;gamma0;truept];
        Ttrue=true;
        Ttrue(expind)=log(Ttrue(expind));
        
        output=[true'; mean(par');
            sqrt(var(par')); mean(sd');
            mean(abs(Tpar'-repmat(Ttrue', nind,1))<1.96*Tsd');
            repmat(mse, 1, nbeta+ngamma+npt);
            repmat(event,1, nbeta+ngamma+npt)]
        
        save simind simind -ASCII;
        save countind countind -ASCII;
        save event event -ASCII;
        save nind nind -ASCII;
        save output output -ASCII;
        save parest parest -ASCII;
        save sdest sdest -ASCII;
        save mse mse -ASCII;
    end
end

