function cov=covest(ID, Y, XX, ZZ, Delta, n, newf, newbeta, newSigma, bb, weight, ...
                    indY, indID, rho, r1, r2)


newbb=sqrtm(newSigma)*bb';
nbeta=length(newbeta)-1;
nsig=size(newSigma,1);
ngamma=nsig*(nsig+1)/2;

nn=sum(Delta==1);
NN=length(Y); mb=size(bb,1);

newXX=XX(:,2:end);
newlambda=newf*exp(newbeta(1));
newLambda=indY*newlambda;
EXZ=exp(repmat(newXX*newbeta(2:end),1,mb)+ZZ*newbb);
[G0,G1,G2,G3]=Gfun(EXZ.*repmat(newLambda, 1, mb), rho, r1, r2);
EG1=G1.*EXZ;  EG2=G2.*EXZ.^2;  EG2G1=G2./G1.*EXZ;
EDG2G1=(G3./G1-G2.^2./G1.^2).*EXZ.^2;

coef1=EG2G1; coef1(Delta==0,:)=-EG1(Delta==0,:);
coef2=EDG2G1; coef2(Delta==0,:)=-EG2(Delta==0,:);
c12=coef1+coef2.*repmat(newLambda,1,mb);

npar=nbeta+ngamma;
EL2=zeros(nn+npar, nn+npar);

if (nsig>1)
 [tempDgamma, tempD2gamma]=scoregamma(newSigma, ngamma, Tbb)
end
if (nsig==1)
tempDgamma=newbb.^2/(2*newSigma^2)-1/(2*newSigma);
tempD2gamma=-newbb.^2/(newSigma^3)+1/(2*newSigma^2);
end

[OY, Oind]=sort(Y(Delta==1));

Dbeta2=zeros(nbeta,nbeta); % complete information
DbetaLambda=zeros(nbeta, nn);
DLambda2=zeros(nn,nn);
Dgamma2=zeros(ngamma,ngamma);

DL=zeros(npar+nn,n); % complete score
DL2=zeros(npar+nn,npar+nn);

for i=1:1:n
    
    TX=newXX(ID==i,:);
    TLambda=newLambda(ID==i);
    Tcoef1=coef1(ID==i,:);
    Tcoef2=coef2(ID==i,:);
    ETcoef2=Tcoef2*weight(i,:)';
    Tc12=c12(ID==i,:);
    ETc12=Tc12*weight(i,:)';
    TY=Y(ID==i);
    TDelta=Delta(ID==i);
    
    tempDbeta=zeros(nbeta,mb);
    tempDLambda=zeros(nn,mb);
    for j=1:1:sum(ID==i)
        tempDbeta=tempDbeta+TDelta(j)*repmat(TX(j,:)',1,mb)...
            +TLambda(j)*TX(j,:)'*Tcoef1(j,:);
        tempDLambda=tempDLambda+(TY(j)>=OY)*Tcoef1(j,:);
        if (TDelta(j)==1)
            tempDLambda(OY==TY(j),:)=tempDLambda(OY==TY(j),:)+1/newlambda(OY==TY(j));
        end
        Dbeta2=Dbeta2+ETc12(j)*TLambda(j)*TX(j,:)'*TX(j,:);
        DbetaLambda=DbetaLambda+ETc12(j)*TX(j,:)'*(TY(j)>=OY)';
        DLambda2=DLambda2+ETcoef2(j)*(TY(j)>=OY)*(TY(j)>=OY)';
        if (TDelta(j)==1)
            DLambda2(OY==TY(j), OY==TY(j))=DLambda2(OY==TY(j), OY==TY(j))-1/newlambda(OY==TY(j))^2;
        end
    end
    Dgamma2=Dgamma2+tempD2gamma*weight(i,:)';  
    
    temp=[tempDbeta;tempDgamma;tempDLambda];
    DL(:,i)=temp*weight(i,:)';
    DL2=DL2+temp*(repmat(weight(i,:),npar+nn,1).*temp)';
end

tempD2=[Dbeta2,               zeros(nbeta, ngamma), DbetaLambda;
        zeros(ngamma, nbeta), Dgamma2,              zeros(ngamma, nn);
        DbetaLambda',         zeros(nn, ngamma),    DLambda2         ];
cov=-tempD2-(DL2-DL*DL');
cov=inv(cov);


