function [newbeta, newf, newSigma]=Mstep(ID, Y, XX, ZZ, Delta, n, ...
    oldalpha, oldbeta, oldSigma, Tbb, weight, indY, indID, rho, r1, r2)

nbeta=length(oldbeta);
mz=size(Tbb,1);
newSigma=Tbb*(repmat(mean(weight), mz, 1).*Tbb)';

NN=length(Y); mb=size(Tbb,2);
Eweight=zeros(NN,mb);
for i=1:1:n
    Eweight(ID==i,:)=repmat(weight(i,:), sum(ID==i),1);
end

[f, f1]=recursive(ID, Y, XX, ZZ, Delta, n, NN, mb, oldalpha, oldbeta, ...
                          Tbb, Eweight, rho, r1, r2);
F=indY*f;     F1=indY*f1;
EXZ=exp(repmat(XX*oldbeta, 1, mb)+ZZ*Tbb);
[G0,G1,G2,G3]=Gfun(EXZ.*repmat(F,1,mb), rho, r1, r2);
EG0=(G0.*Eweight)*repmat(1,mb,1);
EG1=(G1.*EXZ.*Eweight)*repmat(1,mb,1);
EG2=(G2.*EXZ.^2.*Eweight)*repmat(1,mb,1);
EG2G1=(G2./G1.*EXZ.*Eweight)*repmat(1,mb,1);
EDG2G1=((G3./G1-G2.^2./G1.^2).*EXZ.^2.*Eweight)*repmat(1,mb,1);

coef1=EDG2G1; coef1(Delta==0)=-EG2(Delta==0);
coef2=EG2G1;  coef2(Delta==0)=-EG1(Delta==0);
c12=coef2+coef1.*F;

Gamma1=sum(XX(Delta==1,:))+(coef2.*F)'*XX;
Gamma2=sum(f)-1;
XFX=XX.*repmat(F, 1, nbeta)+F1(:, 2:end);
Gamma1beta=XX'*(repmat(c12, 1, nbeta).*XFX);
Gamma1alpha=XX'*(c12.*F1(:,1));
Gamma2beta=sum(f1(:,2:end));
Gamma2alpha=sum(f1(:,1));
HH=[Gamma1beta, Gamma1alpha; Gamma2beta, Gamma2alpha];
newpar=[oldbeta;oldalpha]-inv(HH)*[Gamma1';Gamma2];

newbeta=newpar(1:nbeta); newalpha=newpar(nbeta+1);
[newf, newf1]=recursive(ID, Y, XX, ZZ, Delta, n, NN, mb, newalpha, newbeta, ...
                        Tbb, Eweight, rho, r1, r2);


