function [Tbb, weight]=Estep(ID, Y, XX, ZZ, Delta, n, oldbeta, oldf, oldSigma, ...
                                bb, ww, indY, indID, rho, r1, r2)

% bb values random effects
% ww is weight
% indID indicates Delta==i

Tbb=sqrtm(oldSigma)*bb';

NN=length(Y);   mb=size(Tbb,2);
F=indY*oldf;
EXZ=exp(repmat(XX*oldbeta, 1, mb)+ZZ*Tbb);
[G0,G1,G2,G3]=Gfun(EXZ.*repmat(F,1,mb), rho, r1, r2);

temp=ZZ*Tbb+log(G1);
temp(Delta==0,:)=-G0(Delta==0,:);
weight= exp(indID*temp).*repmat(ww',n,1);
weight=weight./repmat(weight*repmat(1,mb,1), 1,mb);