function [ID, Y,DeltaR, X, tau, DeltaT, ZR, ZT]=...
             simulate(betaR0, lambdaR0, betaT0, lambdaT0, gammaT0, Sigma0, tauC, n)

% survival h(t): lambda0T t; recurrent h(t): lambda0R
db=size(Sigma0,1);
X=[rand(n,1), rand(n,1)<0.5]; ZR=[repmat(1,n,1), X(:,1)]; ZT=repmat(1,n,db);

b=randn(n,db)*sqrtm(Sigma0);


T=-log(rand(n,1))./exp(X*betaT0+(ZT.*b)*gammaT0);
T=sqrt(2*T/lambdaT0);

C=rand(n,1)*tauC;

tau=min(T,C); DeltaT=(T<=C);

ID=0; Y=0; DeltaR=0;
for i=1:1:n
    tempT=0;
    while(tempT<tau(i))
        newtempT=-log(rand(1))/exp(X(i,:)*betaR0+ZR(i,:)*b(i,:)');
        newtempT=tempT+newtempT/lambdaR0;
        if (newtempT<tau(i))
            ID=[ID;i];
            Y=[Y;newtempT];
            DeltaR=[DeltaR;1];
            tempT=newtempT;
        else
            ID=[ID;i];
            Y=[Y;tau(i)];
            DeltaR=[DeltaR;0];
            tempT=newtempT;
        end
    end
end
ID=ID(2:end); Y=Y(2:end); DeltaR=DeltaR(2:end);
