%main program (this is used for general number of random effects
% simulation uses two random effects
% Gaussian_quadrature
w=[2.22939364554E-013, 4.39934099226E-010, 1.08606937077E-007, ...
    7.8025564785E-006, 0.000228338636017, 0.00324377334224,...
    0.0248105208875,0.10901720602,0.286675505363,0.462243669601];
ww=[w,w]';
b=[-5.38748089001, -4.60368244955,-3.94476404012,-3.34785456738, ...
    -2.78880605843, -2.25497400209, -1.73853771212, ...
    -1.2340762154,-0.737473728545,-0.245340708301];
bb=sqrt(2)*[b,-b]';

bb=[kron(bb, 1+zeros(length(bb),1)), kron(1+zeros(length(bb),1), bb)];
ww=kron(ww,ww);
% simulation setting

betaR0=[0.5;-0.5]; lambdaR0=2;
betaT0=[-0.6;1];  lambdaT0=0.5;
%Sigma0=0.8;  gammaT0=0.4;
Sigma0=[1,-0.5;-0.5,0.5]; gammaT0=[0.4;-0.5]; nSig=size(Sigma0,1);
tauC=5;

truepar=[betaR0;betaT0;gammaT0];
for k=1:1:nSig
    for m=k:1:nSig
        truepar=[truepar; Sigma0(k,m)];
    end
end

nbetaR=length(betaR0); nbetaT=length(betaT0); ngammaT=length(gammaT0);

n=100; censorT=0; meanEvent=0; simnum=1;
parest=zeros(simnum, length(truepar));
sdest=parest;

for simind=1:1:simnum
    rand('seed', 123+simind);
    randn('seed',123+simind);

    [ID, Y,DeltaR, X, tau, DeltaT, ZR, ZT]=...
         simulate(betaR0, lambdaR0, betaT0, lambdaT0, gammaT0, Sigma0, tauC, n);
    nR=sum(DeltaR); nT=sum(DeltaT);
     
    XXR=zeros(n,length(Y),nbetaR);
    for k=1:1:nbetaR
        XXR(:,:,k)=repmat(X(:,k),1,length(Y));
    end
    XXT=zeros(n,n,nbetaT);
    for k=1:1:nbetaT
        XXT(:,:,k)=repmat(X(:,k),1,n);
    end
  
    oldbetaR=zeros(nbetaR,1); oldbetaT=zeros(nbetaT,1); oldgammaT=zeros(ngammaT,1);
    oldSigma=Sigma0;
    oldlambdaR=repmat(1/nR,nR,1); oldlambdaT=repmat(1/nT, nT,1);

    epsilon=0.0001; maxiter=2000;
    error=1;iter=0;
    while(error>epsilon & iter<maxiter)

        [weight, Tbb, Ebb, Eb, EeZbR, EeZbT, EZbeZbT, EZb2eZbT]=Estep(oldlambdaR, oldbetaR, oldlambdaT, ...
            oldbetaT, oldgammaT, oldSigma, ww, bb, ID, Y, DeltaR, XXR, tau,DeltaT, XXT, ZR, ZT);

        [newbetaR, newlambdaR, newbetaT, newlambdaT, newgammaT, newSigma]=Mstep...
            (oldbetaR, oldbetaT, oldgammaT, weight, Tbb, Ebb, Eb, EeZbR, EeZbT, EZbeZbT, EZb2eZbT,...
            ID, Y, DeltaR, XXR, tau,DeltaT, XXT, ZR, ZT);

        error=sum([abs(newbetaR-oldbetaR);abs(newlambdaR-oldlambdaR);abs(newbetaT-oldbetaT);...
            abs(newlambdaT-oldlambdaT);abs(newgammaT-oldgammaT); sum(abs(newSigma-oldSigma))']);
        iter=iter+1;
        [iter, error]
        [[betaR0; betaT0; gammaT0; diag(Sigma0)],[newbetaR; newbetaT; newgammaT; diag(newSigma)]]

        oldbetaR=newbetaR; oldlambdaR=newlambdaR; oldbetaT=newbetaT; oldlambdaT=newlambdaT;
        oldgammaT=newgammaT; oldSigma=newSigma;
    end

    cov=CovEst(newbetaR, newlambdaR, newbetaT, newgammaT, newlambdaT, newSigma, weight, ...
        Tbb, EeZbR, EeZbT, EZbeZbT, EZb2eZbT, ID, Y, DeltaR, XXR, tau,DeltaT, XXT, ZR, ZT);
    sd=sqrt(diag(cov));
    
    temp=0; 
    for k=1:1:nSig
        for m=k:1:nSig
            temp=[temp; newSigma(k,m)];
        end
    end
    temp=temp(2:end);
    parest(simind,:)=[newbetaR', newbetaT', newgammaT', temp'];
    sdest(simind,:)=sd([1:nbetaR, nbetaR+nR+(1:(nbetaT+ngammaT)), ...
                      nbetaR+nR+nbetaT+ngammaT+nT+(1:(nSig*(nSig+1)/2))])';
    censorT=(censorT*(simind-1)+mean(DeltaT))/simind;
    meanEvent=(meanEvent*(simind-1)+length(Y)/n-1)/simind;

    if (simind>1)
        [simind, censorT, meanEvent]
        output=[truepar';
            mean(parest(1:simind,:));
            sqrt(var(parest(1:simind,:)));
            mean(sdest(1:simind,:));
            mean(abs(parest(1:simind,:)-repmat(truepar',simind,1))<1.96*sdest(1:simind,:))]

        save parest parest -ASCII;
        save sdest sdest -ASCII;
        save censorT censorT -ASCII;
        save meanEvent meanEvent -ASCII;
        save output output -ASCII;
        save simind simind -ASCII;
    end
end


