function [newbetaR, newlambdaR, newbetaT, newlambdaT, newgammaT, newSigma]=Mstep...
    (betaR, betaT, gammaT, weight, Tbb, Ebb, Eb, EeZbR, EeZbT, EZbeZbT, EZb2eZbT,...
                   ID, Y, DeltaR, XXR, tau,DeltaT, XXT, ZR, ZT)
% XXR(n,N,nbetaR) XXT(n,n,nbetaT), Z(n,ngammaT),
% DeltaR(N,1), DeltaT(n,1)
% EeZbR(n,1), EeZbT(n,1),EZbeZbT(n,ngammaT), EZb2eZbT(ngammaT, ngammaT)

newSigma=Ebb;

N=length(Y); n=length(DeltaT); mb=size(Tbb,2);
ngammaT=length(gammaT); nbetaR=length(betaR); nbetaT=length(betaT);

% partial likelihood for recurrent events (Y, DeltaR, XXR, Z,)
betaXR=zeros(n,N);
for k=1:1:nbetaR
    betaXR=betaXR+betaR(k)*XXR(:,:,k);
end

scoreR=zeros(nbetaR,1);
dscoreR=zeros(nbetaR,nbetaR);
for j=1:1:N
    IDi=ID(j);
    if (DeltaR(j)==1)
    tempweight=(tau>=Y(j)).*exp(betaXR(:,j)).*EeZbR;
    denomR=sum(tempweight);    nomR=zeros(nbetaR,1);
    tempX=zeros(n,nbetaR);
    for k=1:1:nbetaR
        tempX(:,k)=XXR(:,j,k);
    end
    nomR=tempX'*tempweight;
    scoreR=scoreR+tempX(IDi,:)'-nomR/denomR;
    dscoreR=dscoreR-tempX'*(repmat(tempweight,1,nbetaR).*tempX)/denomR+nomR*nomR'/denomR^2;
    end
end
newbetaR=betaR-inv(dscoreR)*scoreR;
newbetaXR=zeros(n,N);
for k=1:1:nbetaR
    newbetaXR=newbetaXR+newbetaR(k)*XXR(:,:,k);
end

newlambdaR=zeros(N,1);
for j=1:1:N
    if (DeltaR(j)==1)
    temp=(tau>=Y(j)).*exp(newbetaXR(:,j)).*EeZbR;
    newlambdaR(j)=1/sum(temp);
    end
end
newlambdaR=newlambdaR(DeltaR==1);


%%%% partial likelihood for terminal event (DeltaT, tau, XXT)
betaXT=zeros(n,n);
for k=1:1:nbetaT
    betaXT=betaXT+betaT(k)*XXT(:,:,k);
end
scoreT=zeros(nbetaT+ngammaT,1);
dscoreT=zeros(nbetaT+ngammaT,nbetaT+ngammaT);
for i=1:1:n
    if (DeltaT(i)==1)
        temp0=(tau>=tau(i)).*exp(betaXT(:,i));
        tempweight=temp0.*EeZbT;  denomT=sum(tempweight);
        tempX=zeros(n,nbetaT);
        for k=1:1:nbetaT
            tempX(:,k)=XXT(:,i,k);
        end
        nomT=[tempX'*tempweight; EZbeZbT'*temp0];
        nom2T=[tempX'*(repmat(tempweight,1, nbetaT).*tempX), ...
                      tempX'*(repmat(temp0,1,ngammaT).*EZbeZbT);
               EZbeZbT'*(repmat(temp0,1,nbetaT).*tempX), ...
                      reshape(EZb2eZbT'*temp0, ngammaT,ngammaT)];
        scoreT=scoreT+[tempX(i,:)'; ZT(i,:)'.*Eb(i,:)']-nomT/denomT;
        dscoreT=dscoreT-nom2T/denomT+nomT*nomT'/denomT^2;
    end
end
newtemp=[betaT;gammaT]-inv(dscoreT)*scoreT;
newbetaT=newtemp(1:nbetaT); newgammaT=newtemp(nbetaT+(1:1:ngammaT));
newbetaXT=zeros(n,n);
for k=1:1:nbetaT
    newbetaXT=newbetaXT+newbetaT(k)*XXT(:,:,k);
end
newEeZbT=(exp((repmat(newgammaT',n,1).*ZT)*Tbb).*weight)*repmat(1,mb,1);

newlambdaT=zeros(n,1);
for i=1:1:n
    if (DeltaT(i)==1)
    temp=(tau>=tau(i)).*exp(newbetaXT(:,i)).*newEeZbT;
    newlambdaT(i)=1/sum(temp);
    end
end
newlambdaT=newlambdaT(DeltaT==1);
