function [weight, Tbb, Ebb, Eb, EeZbR, EeZbT, EZbeZbT, EZb2eZbT]=Estep(lambdaR, betaR, lambdaT, ...
    betaT, gammaT, Sigma, ww, bb, ID, Y, DeltaR, XXR, tau,DeltaT, XXT, ZR, ZT)

% XXR(n,N,nbetaR) XXT(n,n,nbetaT), Z(n,ngammaT),
% DeltaR(N,1), DeltaT(n,1)
% EeZbR(n,1), EeZbT(n,1),EZbeZbT(n,ngammaT), EZb2eZbT(ngammaT, ngammaT)

Tbb=sqrtm(Sigma)*bb';
ngammaT=length(gammaT); N=length(Y); n=length(DeltaT); mb=size(bb,1);
nbetaR=length(betaR); nbetaT=length(betaT);

betaXR=zeros(n,N);
for k=1:1:nbetaR
    betaXR=betaXR+betaR(k)*XXR(:,:,k);
end
betaXT=zeros(n,n);
for k=1:1:nbetaT
    betaXT=betaXT+betaT(k)*XXT(:,:,k);
end

ElambdaR=zeros(N,1);
ElambdaR(DeltaR==1)=lambdaR;

ElambdaT=zeros(n,1);
ElambdaT(DeltaT==1)=lambdaT;

weight=zeros(n, mb);

for i=1:1:n
    tempR=sum((tau(i)>=Y).*exp(betaXR(i,:)').*ElambdaR);
    tempT=sum((tau(i)>=tau).*exp(betaXT(i,:)').*ElambdaT);
    ZbiR=ZR(i,:)*Tbb; ZbiT=(gammaT'.*ZT(i,:))*Tbb;

    weight(i,:)=(sum(ID==i)-1)*ZbiR-tempR*exp(ZbiR)+DeltaT(i)*ZbiT-tempT*exp(ZbiT);
    weight(i,:)=exp(weight(i,:)).*ww';
    if (sum(weight(i,:))>0)
        weight(i,:)=weight(i,:)./sum(weight(i,:));
    end
end

Ebb=(repmat(mean(weight),ngammaT,1).*Tbb)*Tbb';
Eb=weight*Tbb';
EeZbR=(exp(ZR*Tbb).*weight)*repmat(1,mb,1);
gammaZ=repmat(gammaT',n,1).*ZT; Egammab=exp(gammaZ*Tbb);
EeZbT=(Egammab.*weight)*repmat(1,mb,1);
EZbeZbT=zeros(n, ngammaT); EZb2eZbT=zeros(n, ngammaT^2);
for k=1:1:ngammaT
    tempk=ZT(:,k)*Tbb(k,:); 
    EZbeZbT(:,k)=(tempk.*Egammab.*weight)*repmat(1,mb,1);
    for m=1:1:ngammaT
        tempm=ZT(:,m)*Tbb(m,:);
        EZb2eZbT(:, (k-1)*ngammaT+m)=(tempk.*tempm.*Egammab.*weight)*repmat(1,mb,1);
    end
end

