function cov=CovEst(betaR, lambdaR, betaT, gammaT, lambdaT, Sigma, weight, ...
    Tbb, EeZbR, EeZbT, EZbeZbT, EZb2eZbT, ID, Y, DeltaR, XXR, tau,DeltaT, XXT, ZR, ZT)


mb=size(Tbb,2); tempID=ID(DeltaR==0);

N=length(Y); n=length(DeltaT); nR=sum(DeltaR); nT=sum(DeltaT);
ngammaT=length(gammaT); nbetaR=length(betaR); nbetaT=length(betaT);
nSig=size(Sigma,1); ISigma=inv(Sigma);

npar=nbetaR+nR+nbetaT+ngammaT+nT;

betaXR=zeros(n,N);
for k=1:1:nbetaR
    betaXR=betaXR+betaR(k)*XXR(:,:,k);
end
EbetaXR=exp(betaXR);
betaXT=zeros(n,n);
for k=1:1:nbetaT
    betaXT=betaXT+betaT(k)*XXT(:,:,k);
end
EbetaXT=exp(betaXT);

eZbR=exp(ZR*Tbb); eZbT=exp((repmat(gammaT',n,1).*ZT)*Tbb);

ElambdaR=zeros(N,1); ElambdaR(DeltaR==1)=lambdaR;
ElambdaT=zeros(n,1); ElambdaT(DeltaT==1)=lambdaT;

EL2=zeros(npar+nSig*(nSig+1)/2,npar+nSig*(nSig+1)/2); ELL=EL2; ELEL=EL2;
for i=1:1:n
    XXRi=zeros(N,nbetaR);
    for k=1:1:nbetaR
        XXRi(:,k)=XXR(i, :, k)';
    end
    XXTi=zeros(n,nbetaT);
    for k=1:1:nbetaT
        XXTi(:,k)=XXT(i,:,k)';
    end
    indR=(tau(i)>=Y);  indT=(tau(i)>=tau);

    scoreR=zeros(nbetaR+nR,mb);
    scoreR(1:nbetaR,:)=repmat(XXRi(ID==i&DeltaR==1,:)'*repmat(1,sum(ID==i & DeltaR==1),1),1,mb)...
        -XXRi'*(indR.*EbetaXR(i,:)'.*ElambdaR)*eZbR(i,:);
    scoreR((nbetaR+1):end,:)=repmat((ID(DeltaR==1)==i)./lambdaR,1, mb)...
        -(indR(DeltaR==1).*EbetaXR(i,DeltaR==1)')*eZbR(i,:);
    dscoreR=zeros(nbetaR+nR, nbetaR+nR);
    dscoreR(1:nbetaR, 1:nbetaR)=-XXRi'*(repmat(indR.*EbetaXR(i,:)'.*ElambdaR, 1, nbetaR).*XXRi)*EeZbR(i);
    dscoreR(1:nbetaR, (nbetaR+1):end)=...
        -XXRi(DeltaR==1,:)'.*repmat(EbetaXR(i,DeltaR==1).*indR(DeltaR==1)',nbetaR,1)*EeZbR(i);
    dscoreR((nbetaR+1):end, 1:nbetaR)=dscoreR(1:nbetaR, (nbetaR+1):end)';

    scoreT=zeros(nbetaT+ngammaT+nT,mb);
    scoreT(1:nbetaT,:)=DeltaT(i)*repmat(XXTi(i,:)',1,mb)-(XXTi'*(indT.*EbetaXT(i,:)'.*ElambdaT))*eZbT(i,:);
    for k=1:1:ngammaT
        scoreT(nbetaT+k,:)=DeltaT(i)*ZT(i,k)*Tbb(k,:)...
            -sum(indT.*EbetaXT(i,:)'.*ElambdaT)*ZT(i,k)*Tbb(k,:).*eZbT(i,:);
    end
    scoreT((nbetaT+ngammaT+1):end,:)=repmat((tempID(DeltaT==1)==i)./lambdaT,1,mb)...
                                      -(indT(DeltaT==1).*EbetaXT(i,DeltaT==1)')*eZbT(i,:);
    dscoreT=zeros(nbetaT+ngammaT+nT, nbetaT+ngammaT+nT);
    dscoreT(1:nbetaT, 1:nbetaT)=-XXTi'*(repmat(indT.*EbetaXT(i,:)'.*ElambdaT,1,nbetaT).*XXTi)*EeZbT(i);
    dscoreT(1:nbetaT, nbetaT+(1:ngammaT))=-XXTi'*(indT.*EbetaXT(i,:)'.*ElambdaT)*EZbeZbT(i,:);
    dscoreT(1:nbetaT, (nbetaT+ngammaT+1):end)=...
        -XXTi(DeltaT==1,:)'.*repmat(indT(DeltaT==1)'.*EbetaXT(i,DeltaT==1),nbetaT,1)*EeZbT(i);
    dscoreT(nbetaT+(1:ngammaT), 1:nbetaT)=dscoreT(1:nbetaT, nbetaT+(1:ngammaT))';
    dscoreT(nbetaT+(1:ngammaT), nbetaT+(1:ngammaT))=...
        -sum(indT.*EbetaXT(i,:)'.*ElambdaT)*reshape(EZb2eZbT(i,:)',ngammaT,ngammaT);
    dscoreT(nbetaT+(1:ngammaT), (nbetaT+ngammaT+1):end)=...
        -EZbeZbT(i,:)'*(indT(DeltaT==1)'.*EbetaXT(i,DeltaT==1));
    dscoreT((nbetaT+ngammaT+1):end, 1:(nbetaT+ngammaT))=dscoreT(1:(nbetaT+ngammaT),(nbetaT+ngammaT+1):end)';
    
    scoreSig=zeros(nSig*(nSig+1)/2, mb);
    dscoreSig=zeros(nSig*(nSig+1)/2, nSig*(nSig+1)/2);
    ind1=0;
    for k=1:1:nSig
        for m=k:1:nSig
            ind1=ind1+1;
            dkm=zeros(nSig,nSig); dkm(k,m)=1; dkm(m,k)=1;
            scoreSig(ind1,:)=(diag(Tbb'*(ISigma*dkm*ISigma)*Tbb))'/2-sum(sum(ISigma.*dkm))/2;
            ind2=0;
            for p=1:1:nSig
                for q=p:1:nSig
                    ind2=ind2+1;
                    dpq=zeros(nSig,nSig); dpq(p,q)=1; dpq(q,p)=1;
                    temp=ISigma*dpq*ISigma*dkm*ISigma+ISigma*dkm*ISigma*dpq*ISigma;
                    dscoreSig(ind1,ind2)=-(diag(Tbb'*temp*Tbb)/2)'*weight(i,:)'...
                        +sum(sum((ISigma*dpq*ISigma).*dkm))/2;
                    dscoreSig(ind2,ind1)=dscoreSig(ind1,ind2);
                end
            end
        end
    end
    
    
    EL2(1:(nbetaR+nR), 1:(nbetaR+nR))=EL2(1:(nbetaR+nR), 1:(nbetaR+nR))+dscoreR;
    EL2(nbetaR+nR+(1:(nbetaT+ngammaT+nT)),nbetaR+nR+(1:(nbetaT+ngammaT+nT)))=...
        EL2(nbetaR+nR+(1:(nbetaT+ngammaT+nT)),nbetaR+nR+(1:(nbetaT+ngammaT+nT)))+dscoreT;
    EL2(npar+(1:(nSig*(nSig+1)/2)), npar+(1:(nSig*(nSig+1)/2)))=...
        EL2(npar+(1:(nSig*(nSig+1)/2)), npar+(1:(nSig*(nSig+1)/2)))+dscoreSig;

    score=[scoreR;scoreT; scoreSig]; Escore=score*weight(i,:)';
    ELEL=ELEL+Escore*Escore';
    ELL=ELL+score*(repmat(weight(i,:)',1, npar+nSig*(nSig+1)/2).*score');
end

EL2=EL2-diag([zeros(nbetaR,1); 1./lambdaR.^2; zeros(nbetaT+ngammaT,1); 1./lambdaT.^2; ...
               zeros(nSig*(nSig+1)/2,1)]);

cov=-EL2-(ELL-ELEL);
cov=inv(cov);


