% Gaussian_quadrature
w=[2.22939364554E-013, 4.39934099226E-010, 1.08606937077E-007, 7.8025564785E-006, ...
        0.000228338636017, 0.00324377334224, 0.0248105208875,0.10901720602, 0.286675505363, ...
        0.462243669601];
ww=[w,w]';
b=[-5.38748089001, -4.60368244955, -3.94476404012, -3.34785456738,-2.78880605843, -2.25497400209,...
        -1.73853771212, -1.2340762154, -0.737473728545, -0.245340708301];
bb=sqrt(2)*[b,-b]';
m=length(bb);

beta0=1; Sigma0=[1,-0.5;-0.5,1];

sigma110=Sigma0(1,1);
sigma120=Sigma0(1,2);
sigma220=Sigma0(2,2);

tau=2;
n=100;

simnum=500;
parest=zeros(4, simnum);
sdest=zeros(4, simnum);
outmse=zeros(4,1);

startnum=0;
count=zeros(simnum,1);

for sim=(startnum+1):1:simnum
    
    rand('seed',12587+sim);
    randn('seed',68312+sim);
    
    [ID,X,Z1,Z2,Y,Delta]=simulation(beta0,Sigma0,tau,n);
    Delta(Y==max(Y))=0;
    N=length(ID);
    
    
    %MLE estimation method
    nn=sum(Delta);
    yy=Y(Delta==1);
    indy=(repmat(Y,1,nn)>=repmat(yy',N,1));
    
    indsub=zeros(n,N);
    Eindsub=zeros(N,N);
    for i=1:1:n
        indsub(i,ID==i)=1;
        Eindsub(ID==i, :)=repmat(indsub(i,:),sum(ID==i),1);
    end
    
    BB=repmat(bb',N,1);   
    XX=repmat(X,1,m);
    
    % intital values for parameters
    tbeta=beta0;  tsig11=sigma110; tsig12=sigma120; tsig22=sigma220;
    
    Tsigma=repmat(tsig11.*Z1.*Z1+2*tsig12*Z1.*Z2+tsig22*Z2.*Z2,1,m);
  
    HZ=(1+0.5*Y).^2-1;
    p=exp(-tbeta*XX-sqrt(Tsigma).*BB);
    %pijkl
    q=repmat(HZ,1,m)+p; %qijkl
    temp=log(p)-(1+repmat(Delta,1,m)).*log(q);
    r=exp(indsub*temp); % rikl
    alpha=r*ww;
    WR=repmat(ww',n,1).*r./repmat(alpha,1,m);
    
    DR=zeros(N,m);
    for i=1:1:n
        DR(ID==i,:)=repmat(WR(i,:),sum(ID==i),1);
    end
    temp1=(1+repmat(Delta, 1,m))./q;
    gamma=-indsub*(repmat((DR.*temp1)*repmat(1,m,1),1,nn).*indy); % n by s
    
    hz=-1./(sum(gamma))';
    
    
    indHZ=4+(1:nn)'; indPAR=(1:4)';
    %indexp=[indHZ; indPAR(2); indPAR(4)];
    %truepar=[beta0;log(sigma110);sigma120;log(sigma220)];
    indexp=[indHZ];
    truepar=[beta0;sigma110;sigma120;sigma220];
    
    initialz=[truepar;log(hz)];
    options=optimset('GradObj', 'on', 'Hessian', 'on', 'Display', 'iter','maxiter',100);
    [z, fval, exitflag, output, grad, hessian]=fminunc(@fgh, initialz,options, ...
        ID, Y, X, Z1, Z2, Delta, N,n, ww, BB, XX, ...
        indsub, Eindsub, indy, m, nn, indHZ, indPAR, indexp);
    parest(:,sim)=[z(indPAR(1)); abs(z(indPAR(2))); z(indPAR(3));
                   abs(z(indPAR(4)))];
        
    temp=inv(hessian);
    temp=temp(indPAR,indPAR);
    if (min(diag(temp))>0)
       count(sim)=1;
   end
   sdest(:,sim)=sqrt(diag(temp))/sqrt(n);
    
    
    %print iteration result
    if (sim>4)
        [sim, sum(count)]
        Tsim=sum(count);
        simind=(1:simnum)';
        simind=simind(count==1);
        qa=mean(parest(:,simind)');
        qb=sum((abs(parest(:,simind)-repmat(truepar,1,Tsim))<1.96*sdest(:,simind))')/Tsim;
        qc=mean(sdest(:,simind)');
        qd=sqrt(var(parest(:,simind)'));
        qe=sum(power(parest(:,simind)-repmat(truepar,1,Tsim),2)')/Tsim;
        output=[truepar'; qa;qb;qc;qd;qe]

        save output output -ASCII;
        save parest parest -ASCII;
        save sdest sdest -ASCII;
        save startnum sim -ASCII;
    end
    
end

