% testing for tau^2=0/JAMA data
load hazardratio.txt

tempdata=hazardratio;
tempdata=tempdata(1:6,:);
%tempdata=tempdata(7:end,:);
y=log(tempdata(:,1));
lb=tempdata(:,2);
ub=tempdata(:,3);
lb(lb==0)=0.005;
sig2=(log(ub)-log(lb))/3.92;
sig2=sig2.^2;

% Jackon's data
%y=[0.31;-0.57;0.01; 0.38;0.21;-1.11;1.26;-0.20;0.36];
%sig2=[0.54;0.17;0.62;0.24;0.39;0.16;2.77;0.09;0.23];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
K=length(y);
w=1./sig2;
denom=(sum(w)-sum(w.^2)/sum(w));
unmu=sum(w.*y)/sum(w);
untau2=(sum(w.*(y-unmu).^2)-(K-1))/denom;
untau2=max(untau2,0);
neww=1./(sig2+untau2);
unmu=sum(neww.*y)/sum(neww);
varmu=1/sum(neww);
sd=sqrt(1/sum(neww));
CI=[];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% doubel sampling
N=1000;
% Double bootstrapping
testZ=randn(K,N).*repmat(sqrt(untau2+sig2),1,N);
unZ=(w'*testZ)/sum(w);
testtau2=(w'*(testZ-repmat(unZ,K,1)).^2-(K-1))/denom;
testtau2=max(testtau2,0);
MCmu=zeros(N,N);
for q=1:1:N
    testZ=randn(K,N).*repmat(sqrt(testtau2(q)+sig2),1,N);
    unZ=(w'*testZ)/sum(w);
    qtau2=(w'*(testZ-repmat(unZ,K,1)).^2-(K-1))/denom;
    qtau2(qtau2<0)=0;
    neww=1./(repmat(sig2,1,N)+repmat(qtau2,K,1));
    MCmu(q,:)=sum(neww.*testZ)./sum(neww)+unmu;
end
MCmu=reshape(MCmu, N^2,1);
CI=[CI;[prctile(MCmu,2.5), prctile(MCmu,97.5)]];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DL method
CI=[CI; [unmu+norminv(0.025)*sqrt(varmu), unmu+norminv(0.975)*sqrt(varmu)]];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Quantile approximation

c1=icdf('chi2',0.025, K-1); c2=icdf('chi2',0.975,K-1);

test=(0:0.0001:1)';
temp=Qtau2(y,sig2,test);
tauL=0; tauU=1;
for j=1:1:length(test)
    if(temp(j)>c2);
        tauL=test(j);
    end
    if(temp(length(test)-j+1)<c1)
        tauU=test(length(test)-j+1);
    end
end



N=25000; npt=6; IV=zeros(npt,2);
for j=1:1:npt
    tauj=(tauU-tauL)*(j-1)/npt+tauL;
    newy=unmu+randn(K,N).*repmat(sqrt(sig2+tauj),1,N);
    
    newmu=(w'*newy)/sum(w);
    newtau2=((w'*(newy-repmat(newmu,K,1)).^2)-(K-1))/denom;
    newtau2=max(newtau2,0);
    neww=1./(repmat(sig2,1,N)+repmat(newtau2,K,1));
    newvarmu=1./sum(neww);
    MM=(newmu-unmu)./sqrt(newvarmu);
    IV(j,:)=[prctile(MM',2.5), prctile(MM',97.5)];
end

newbound=max(IV(:,2));
CI=[CI; [unmu-newbound*sqrt(varmu), unmu+newbound*sqrt(varmu)]];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% profile likelihood method
options=optimset('GradObj','off', 'TolX', 0.000001);
[x]=fminsearch(@fgh, [unmu; untau2], options, y, sig2);
mlemu=x(1); mletau2=x(2); vmle=1/(sum(1./(sig2+mletau2)));

lik=-fgh(x, y, sig2); con=chi2inv(0.975,1);
oldLmu=-10; newLmu=mlemu;

while (abs(newLmu-oldLmu)>1e-4)
    tempLmu=(newLmu+oldLmu)/2;
    pf2=profile(tempLmu, y, sig2, untau2);
    if((pf2-lik)>(-con))
        newLmu=tempLmu;
    else
        oldLmu=tempLmu;
    end
end

oldUmu=10; newUmu=mlemu;

while (abs(newUmu-oldUmu)>1e-4)
    tempUmu=(newUmu+oldUmu)/2;
    pf2=profile(tempUmu, y, sig2, untau2);
    if((pf2-lik)>(-con))
        newUmu=tempUmu;
    else
        oldUmu=tempUmu;
    end
end
CI=[CI;[oldLmu, oldUmu]];


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MLE approach

CI=[CI; [mlemu+norminv(0.025)*sqrt(vmle), mlemu+norminv(0.975)*sqrt(vmle)]];

column=['DS '; 'DL '; 'QA '; 'PL '; 'ML '];
[column, num2str(exp(CI))]
