load hazardratio.txt %JAMA data
N=1000;

tempdata=hazardratio;
%tempdata=tempdata(1:6,:);
tempdata=tempdata(7:end,:);
y=log(tempdata(:,1));
lb=tempdata(:,2);
ub=tempdata(:,3);
lb(lb==0)=0.005;
sig2=(log(ub)-log(lb))/3.92;
sig2=sig2.^2;

K=length(y);

w=1./sig2;


denom=(sum(w)-sum(w.^2)/sum(w));
unmu=sum(w.*y)/sum(w);
untau2=(sum(w.*(y-unmu).^2)-(K-1))/denom;
untau2=max(untau2,0);
neww=1./(sig2+untau2);
unmu=sum(neww.*y)/sum(neww);
sd=sqrt(1/sum(neww));

options=optimset('GradObj', 'on', 'Hessian', 'on', 'Display', 'off');
[x, lik]=fminunc(@fgh, [unmu;0.001], options, y, sig2);
%Bayesian sample

% Double bootstrapping
testZ=randn(K,N).*repmat(sqrt(untau2+sig2),1,N);
unZ=(w'*testZ)/sum(w);
testtau2=(w'*(testZ-repmat(unZ,K,1)).^2-(K-1))/denom;
testtau2=max(testtau2,0);
MCmu=zeros(N,N);
for q=1:1:N
    testZ=randn(K,N).*repmat(sqrt(testtau2(q)+sig2),1,N);
    unZ=(w'*testZ)/sum(w);
    qtau2=(w'*(testZ-repmat(unZ,K,1)).^2-(K-1))/denom;
    qtau2(qtau2<0)=0;
    neww=1./(repmat(sig2,1,N)+repmat(qtau2,K,1));
    MCmu(q,:)=sum(neww.*testZ)./sum(neww)+unmu;
end
MCmu=reshape(MCmu, N^2,1);
exp(prctile(MCmu, [2.5, 97.5]))
exp([unmu-1.96*sd, unmu+1.96*sd])

%%%%%%%%%%%%%%%%%%%%%%%%%%
%% data from Brockwell and Gordon

temp=[-0.3289, 0.0389;
    -0.3845, 0.0412;
    -0.2158, 0.0753;
    -0.2196, 0.0205;
    -0.2257, 0.0352;
    0.1246, 0.0096];
y=temp(:,1);
sig2=temp(:,2);
K=length(y);

w=1./sig2;


denom=(sum(w)-sum(w.^2)/sum(w));
unmu=sum(w.*y)/sum(w);
untau2=(sum(w.*(y-unmu).^2)-(K-1))/denom;
untau2=max(untau2,0);
neww=1./(sig2+untau2);
unmu=sum(neww.*y)/sum(neww);

options=optimset('GradObj', 'on', 'Hessian', 'on', 'Display', 'off');
[x, lik]=fminunc(@fgh, [unmu;0.001], options, y, sig2);
%Bayesian sample
N=1000;

% Double bootstrapping
testZ=randn(K,N).*repmat(sqrt(untau2+sig2),1,N);
unZ=(w'*testZ)/sum(w);
testtau2=(w'*(testZ-repmat(unZ,K,1)).^2-(K-1))/denom;
testtau2=max(testtau2,0);
MCmu=zeros(N,N);
for q=1:1:N
    testZ=randn(K,N).*repmat(sqrt(testtau2(q)+sig2),1,N);
    unZ=(w'*testZ)/sum(w);
    qtau2=(w'*(testZ-repmat(unZ,K,1)).^2-(K-1))/denom;
    qtau2(qtau2<0)=0;
    neww=1./(repmat(sig2,1,N)+repmat(qtau2,K,1));
    MCmu(q,:)=sum(neww.*testZ)./sum(neww)+unmu;
end
MCmu=reshape(MCmu, N^2,1);
(prctile(MCmu, [2.5, 97.5]))
[-0.3700, -0.1690, 0.0312]
