load K;
load tau2;

%K=10; tau2=0.06;
% in Bockwell and Gorden, K is from 3 to 35; tau2 is from 0.0 to 0.1
% mu=0.5; sig2 is from Chi(1)*0.25, truncated at (0.009,0.6)

mu=0.5; simnum=10000; alpha=5;

bk=2.061+4.902/K+0.756/sqrt(K)-0.958/log(K);
CI=zeros(simnum,5);
cover=zeros(1, 5);

load simind;
if (simind<simnum)

    
%    load cover;
%    load CI;
    
    startind=simind+1;
    
    for simind=startind:1:simnum
        randn('seed', simind);
        
        sig2=0.25*(randn(K,1).^2); sig2=sig2(sig2>0.009 & sig2<0.6);
        while (length(sig2)<K)
            tempsig2=0.25*(randn(K,1).^2);
            tempsig2=[sig2; tempsig2];
            sig2=tempsig2(tempsig2>0.009 & tempsig2<0.6);
        end
        sig2=sig2(1:K);
        
        w=1./sig2;
        
        y=mu+randn(K,1).*sqrt(tau2+sig2);
        denom=(sum(w)-sum(w.^2)/sum(w));
        unmu=sum(w.*y)/sum(w);
        untau2=(sum(w.*(y-unmu).^2)-(K-1))/denom;
        untau2=max(untau2,0);
        neww=1./(sig2+untau2);
        unmu=sum(neww.*y)/sum(neww);
        varmu=1/sum(neww);
        
        %Bayesian sample
        N=1000;
        % Double bootstrapping
        testZ=randn(K,N).*repmat(sqrt(untau2+sig2),1,N);
        unZ=(w'*testZ)/sum(w);
        testtau2=(w'*(testZ-repmat(unZ,K,1)).^2-(K-1))/denom;
        testtau2=max(testtau2,0);
        MCmu=zeros(N,N);
        for q=1:1:N
            testZ=randn(K,N).*repmat(sqrt(testtau2(q)+sig2),1,N);
            unZ=(w'*testZ)/sum(w);
            qtau2=(w'*(testZ-repmat(unZ,K,1)).^2-(K-1))/denom;
            qtau2(qtau2<0)=0;
            neww=1./(repmat(sig2,1,N)+repmat(qtau2,K,1));
            MCmu(q,:)=sum(neww.*testZ)./sum(neww)+unmu;
        end
        MCmu=reshape(MCmu, N^2,1);
        
        % Doulbe sampling, DL method, quantile approximation
        cover(1)=(cover(1)*(simind-1)+(mu>prctile(MCmu,alpha/2))*(mu<prctile(MCmu,100-alpha/2)))/simind;
        cover(2)=(cover(2)*(simind-1)+(abs(mu-unmu)<norminv(1-alpha/(2*100))*sqrt(varmu)))/simind;
        cover(3)=(cover(3)*(simind-1)+(abs(mu-unmu)<bk*sqrt(varmu)))/simind;
        
        CI(simind,1)=(prctile(MCmu,100-alpha/2)-prctile(MCmu,alpha/2));
        CI(simind,2)=2*norminv(1-alpha/(2*100))*sqrt(varmu);
        CI(simind,3)=2*bk*sqrt(varmu);
        
        % MLE approach
        options=optimset('GradObj','off', 'TolX', 0.000001);
        [x]=fminsearch(@fgh, [mu; tau2], options, y, sig2);
        mlemu=x(1); mletau2=x(2); vmle=1/(sum(1./(sig2+mletau2)));
        cover(4)=(cover(4)*(simind-1)+(abs(mu-mlemu)<norminv(1-alpha/(2*100))*sqrt(vmle)))/simind;
        CI(simind,4)=2*norminv(1-alpha/(2*100))*sqrt(vmle);
        
        
        % profile likelihood method
        lik=-fgh(x, y, sig2); con=chi2inv(1-alpha/100,1);
        oldLmu=-10; newLmu=mlemu;
        
        while (abs(newLmu-oldLmu)>1e-4)
           tempLmu=(newLmu+oldLmu)/2;
            pf2=profile(tempLmu, y, sig2, tau2);
            if((pf2-lik)>(-con))
                newLmu=tempLmu;
            else
                oldLmu=tempLmu;
            end
        end
              
          oldUmu=10; newUmu=mlemu;
        
        while (abs(newUmu-oldUmu)>1e-4)
           tempUmu=(newUmu+oldUmu)/2;
            pf2=profile(tempUmu, y, sig2, tau2);
            if((pf2-lik)>(-con))
                newUmu=tempUmu;
            else
                oldUmu=tempUmu;
            end
        end  
        cover(5)=(cover(5)*(simind-1)+(mu<oldUmu)*(mu>oldLmu))/simind;
        CI(simind,5)=(oldUmu-oldLmu);
        
        
        if (simind>1 & mod(simind,100)==1)
            simind
            [cover]
            mean(CI(1:simind,:))
            median(CI(1:simind,:))
            save simind simind -ASCII;
            save cover cover -ASCII;
            save CI CI -ASCII;
            
        end
    end
    
end
