function [Y1, Delta1, Z1, Y2, Delta2, Z2]=...
             simulation(beta0, sigb20, lambda10, lambda20, n, rho1, r1, rho2, r2, tau)
         
tempZ=rand(n,1);           
Z1=[[zeros(n/2,1); 1+zeros(n/2,1)], tempZ];
Z2=[[zeros(n/2,1); 1+zeros(n/2,1)], tempZ];
b=sqrt(sigb20)*randn(n,1);
EZbeta1=exp(Z1*beta0+b);
EZbeta2=exp(Z2*beta0+b);


if (rho1>0)
    T1=-log(rand(n,1))*rho1+1;
    T1=(power(T1, 1/rho1)-1)./(lambda10*EZbeta1);
end
if (rho2>0)
    T2=-log(rand(n,1))*rho2+1;
    T2=(power(T2, 1/rho2)-1)./(lambda20/2*EZbeta2);
    T2=power(T2, 1/2);
end
if (rho1==0)
    newr1=1/r1;
    T1=exp(-log(rand(n,1))/newr1)-1;
    T1=T1/(1/newr1)./(lambda10*EZbeta1);
end
if (rho2==0)
    newr2=1/r2;
    T2=exp(-log(rand(n,1))/newr2)-1;
    T2=T2/(1/newr2)./(lambda20/2*EZbeta2);
    T2=power(T2,1/2);
end

C1=min(rand(n,1)*5, tau);
C2=min(rand(n,1)*5, tau);

Y1=min(T1, C1); Delta1=(T1<=C1);
Y2=min(T2, C2); Delta2=(T2<=C2);
    